<?php

    use App\Http\Controllers\CartController;
    use App\Http\Controllers\CategoryController;
    use App\Http\Controllers\CommonCntroller;
    use App\Http\Controllers\HousingProjectController;
    use App\Http\Controllers\SendPdfController;
    use App\Http\Controllers\StreetLaneController;
    use App\Http\Controllers\SubCategoryController;
    use App\Http\Controllers\UnitBlockController;
    use App\Http\Controllers\UnitSectorController;
    use App\Http\Controllers\V1\AccountController;
    use App\Http\Controllers\V1\InstallmentController;

    use App\Http\Controllers\V1\Auth\CsPartyAuthController;
    use App\Http\Controllers\V1\CityController;
    use App\Http\Controllers\V1\CompanyController;
    use App\Http\Controllers\V1\HousingChargesScheduleController;
    use App\Http\Controllers\V1\HousingSaleTokenChillController;
    use App\Http\Controllers\V1\HousingUnitPlotController;
    use App\Http\Controllers\v1\LedgerDetailController;
    use App\Http\Controllers\V1\LedgerMainController;

    use App\Http\Controllers\PaymentController;
    use App\Http\Controllers\SaleDeedMainController;
    use App\Http\Controllers\TestController;
use App\Http\Controllers\V1\BlogCotroller;
use App\Http\Controllers\V1\GalleryController;
use App\Http\Controllers\V1\HousingSaleInstPayMain;
    use App\Http\Controllers\V1\HousingUnitPremiumController;
    use App\Http\Controllers\V1\ImageController;
    use App\Http\Controllers\V1\NewzController;
    use App\Http\Controllers\V1\ReportController;
    use App\Http\Controllers\V1\SliderController;
    use App\Http\Controllers\V1\TeamController;
    use App\Http\Controllers\v1\TokenMainController;
    use App\Http\Controllers\v1\TransactionController;
    use App\Http\Controllers\WebhookController;
    use Illuminate\Support\Facades\Route;
    use App\Mail\TestMail;

/*  
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API! test
|
*/

    Route::get('/webhook', [WebhookController::class, 'verify']);
    Route::post('/webhook', [WebhookController::class, 'receive']);
    Route::get('/webhook/get-message',[WebhookController::class,'getMessage']);
    Route::put('/webhook/update-message',[WebhookController::class,'update']);
    
    Route::get('/send-mail', function () {
        $data = ['message' => 'This is a test email from Laravel!'];
    
        Mail::to('sparksolutionzoo7@gmail.com')->send(new TestMail($data));
    
        return "Email has been sent!";
    });


    Route::controller(TestController::class)->group(function(){
        Route::post('/payment/initiate','initiatePaymentApi');
        Route::post('/payment/callback','handleCallbackApi');
        Route::get('index','index');
    });

    Route::post('add-subscription-message' ,[CommonCntroller::class,'addSubscription']);
    Route::get('get-subscription-message' ,[CommonCntroller::class,'getSubscriptions']);

    Route::post('add-contact-message' ,[CommonCntroller::class,'addContactUsMessage']);
    Route::get('get-contact-message' ,[CommonCntroller::class,'getContactUsMessages']);

    Route::get('blog/{id?}',[BlogCotroller::class,'blog']);

    Route::get('/newz/get/{id?}',[NewzController::class,'get']);
    Route::get('/gallery/get/{id?}',[GalleryController::class,'get']);
    Route::get('/slider/get/{id?}',[SliderController::class,'get']);
    Route::get('/project-overview/get',[CommonCntroller::class,'getProjectOverview']);
    Route::get('/project-overview/update',[CommonCntroller::class,'updateProjectOverView']);
    Route::get('/amenities/get',[CommonCntroller::class,'']);

    Route::middleware('auth:sanctum')->group(function () {  
        Route::prefix('blog')->controller(BlogCotroller::class)->group(function () {
            Route::post('store', 'addBlog');
            Route::get('/', 'addBlog');
            Route::put('update/{id}', 'edit');
            Route::put('change-status/{id}/{status}', 'changeStatus');
        });

        Route::prefix('user')->controller(CsPartyAuthController::class)->group(function () {
            Route::post('/logout', 'logout');
            Route::put('change-password', 'changePassword');
            Route::post('update-profile', 'updateProfile');

            Route::get('email-check','duplicateEmailCheck')->withoutMiddleware('auth:sanctum');
            Route::get('cnic-check','duplicateCnicCheck')->withoutMiddleware('auth:sanctum');
            Route::get('phone-check','duplicatePhoneCheck')->withoutMiddleware('auth:sanctum');

            Route::get('check-login','checkLogin');
        });

        Route::prefix('installments')->controller(InstallmentController::class)->group(function () {
            Route::get('plots-record', 'plotsRecord');            
            // Route::get('customer-plot-record', 'customerPlotsRecord');
            Route::get('plots-installment', 'plotInstallments');
        }); // vps

        Route::prefix('reports')->controller(ReportController::class)->group(function () {
            Route::get('dashboard', 'dashboardReport');
        }); // vps

        Route::prefix('gallery')->controller(GalleryController::class)->group(function(){

            Route::post('store','storeImage');
            Route::post('update/{id}' ,'update');
            Route::put('change-status/{id}/{status}','changeStatus');
        }); // vps

        Route::prefix('newz')->controller(NewzController::class)->group(function(){
            Route::post('store','store');
            Route::post('update/{id}' ,'update');
            Route::put('change-status/{id}/{status}','changeStatus');
        }); // vps

        Route::prefix('slider')->controller(SliderController::class)->group(function(){
            Route::post('store','store');
            Route::post('update/{id}' ,'update');
            Route::put('change-status/{id}/{status}','changeStatus');
        }); // vps

        // Route::put('change-password','changePassword');

        Route::prefix('plots')->controller(HousingUnitPlotController::class)->group(function () {
            Route::get('plot-report', 'plotReport');
            Route::get('inventory-report', 'inventoryReport');
        }); // vps
    });

    Route::post('upload', [SendPdfController::class, 'upload']);
    Route::post('uploadv1', [SendPdfController::class, 'uploadV1']);

    Route::prefix('accounts')->controller(AccountController::class)->group(function () {
        Route::post('/store', 'store'); // local server
        Route::get('/index/{id?}', 'index');
        Route::get('/server-id', 'serverId'); // local server
        Route::put('/update', 'update');
        Route::put('change-updated-status', 'changeUpdatedStatus');
        Route::put('edit-by-sql', 'editbySql'); // local server
        Route::get('add-to-sql', 'addToSql');
        Route::put('update-account', 'updateAccount');
    });

    Route::prefix('unit_premiums')->controller(HousingUnitPremiumController::class)->group(function () {
        Route::post('/store', 'store');
        Route::get('/index/{id?}', 'index');
        Route::get('/server-id', 'serverId');
        Route::put('/update', 'update');
        Route::put('change-updated-status', 'changeUpdatedStatus');
        Route::put('edit-by-sql', 'editbySql');

        Route::get('premium-list', 'premiumList'); //used
    });

    Route::prefix('housing-unit-plot')->controller(HousingUnitPlotController::class)->group(function () {
        Route::post('/store', 'store');
        Route::get('/index/{id?}', 'index');
        Route::get('/server-id', 'serverId');
        Route::put('/update', 'update');
        Route::put('/change-updated-status', 'changeUpdatedStatus');
        Route::put('/edit-by-sql', 'editBySql');
        Route::get('plot-list/{id?}', 'plotList');
        Route::get('min-max-values', 'mixMaxValues');
        Route::get('compare-plot/{id?}', 'comparePlot');
    });

    Route::prefix('cs-party')->controller(CsPartyAuthController::class)->group(function () {
       
        Route::post('/login', 'login');
        Route::post('/add-customer', 'addCustomer');
        Route::post('send-otp', 'sendOpt');
        Route::put('change-phone-no', 'changePhoneNo');
        Route::put('verify-otp', 'verifyOtp');
        Route::get('add-to-sql', 'addToSql');
        Route::post('delete/{id}', 'delete');
        Route::post('token-data', 'tokenData');
        Route::get('registered', 'registered');
        Route::post('forget-password', 'ForgetPassword');
        Route::put('reset-password', 'ResetPassword');
        Route::get('duplicate-name-check/{name}','customerDuplicateNameCheck');
        Route::get('fetch-tokens', 'fetchTokens'); // used in app
        Route::put('delete-account','deleteAccount');
    });

    Route::prefix('transactions')->controller(TransactionController::class)->group(function () {
        Route::get('fetch', 'fetchTransaction');
        Route::put('change-update-status', 'changeUpdatedStatus');
    });

    Route::prefix('payments')->controller(PaymentController::class)->group(function () {
        Route::post('/initiate','initiatePaymentApi');
        Route::post('/callback','handleCallbackApi');

         Route::post('installment-initiate', 'payInstallmentInitiate');
         Route::post('installment-callback', 'payInstallmentCallback');
    }); // vps

    Route::prefix('team')->controller(TeamController::class)->group(function(){
        Route::get('get/{id?}','get');
        Route::post('store','store');
        Route::post('update/{id}','update');
        Route::put('change-status/{id}','changeStatus');
    });

    //contributed by shahzad
    Route::prefix('v1')->group(function () {
        Route::prefix('housing-unit-plot')
            ->controller(HousingUnitPlotController::class)->group(function () {
                Route::get('compare-plot/{id?}', 'comparePlot');
            });
            
        Route::prefix('payments')->controller(PaymentController::class)->group(function () {
                Route::get('index', 'indexV1');
                Route::get('show/{id}', 'showV1');
                Route::get('fetch-token-transactions', 'fetchTokenTransactionsV1');
            });
    });