<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('token_mains', function (Blueprint $table) {
            $table->id();
            $table->string('server_id');
            $table->string('Token_ID')->nullable();
            $table->string('Comp_ID')->nullable();
            $table->string('Ledger_ID')->nullable();
            $table->string('T_Date')->nullable();
            $table->string('Cust_ID')->nullable();
            $table->string('Cust_ID_REFERENCE')->nullable();
            $table->string('Token_Amt')->nullable();
            $table->string('Adj_Token')->nullable();
            $table->string('Valid_Date')->nullable();
            $table->string('Pay_Acco')->nullable();
            $table->string('T_Detail')->nullable();
            $table->string('Cancelled_By')->nullable();
            $table->string('Cancelled_On')->nullable();
            $table->string('Cancel_Ledger_ID')->nullable();
            $table->string('Cancel_Amt')->nullable();
            $table->string('Cancel_Reason')->nullable();
            $table->string('Cancel_L_Remarks')->nullable();
            $table->string('Receipt_Booking')->nullable();
            $table->string('Nomi_Name')->nullable();
            $table->string('CNIC_No')->nullable();
            $table->string('Passport_No')->nullable();
            $table->string('Son_Of')->nullable();
            $table->string('Addr1')->nullable();
            $table->string('Mob_No')->nullable();
            $table->string('Relation_Ship')->nullable();
            $table->string('SP_ID')->nullable();
            $table->string('RP_ID')->nullable();
            $table->string('Affilate_ID')->nullable();
            $table->string('Total_Price')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('token_mains');
    }
};
