<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ledger_details', function (Blueprint $table) {
            $table->id();
            $table->string('server_id')->nullable();
            $table->string('Comp_ID')->nullable();
            $table->string('BT_No')->nullable();
            $table->string('Acco_LID')->nullable();
            $table->string('R_Acco_LID')->nullable();
            $table->string('Debit')->nullable();
            $table->string('Credit')->nullable();
            $table->string('L_Remarks')->nullable();
            $table->string('L_QTY')->nullable();
            $table->string('Accrual_Date')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ledger_details');
    }
};
