<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ledger_mains', function (Blueprint $table) {
            $table->id();
            $table->string('server_id');
            $table->string('Ledger_ID')->nullable();
            $table->string('Comp_ID')->nullable();
            $table->string('BT_No')->nullable();
            $table->string('L_Date')->nullable();
            $table->string('Descr')->nullable();
            $table->string('Acco_LID')->nullable();
            $table->string('L_Amount')->nullable();
            $table->string('Per_ID')->nullable();
            $table->string('User_ID')->nullable();
            $table->string('Created_On')->nullable();
            $table->string('Posted_By')->nullable();
            $table->string('Posted_On')->nullable();
            $table->string('Cancelled_By')->nullable();
            $table->string('Cancelled_On')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ledger_mains');
    }
};
