<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('housing_projects', function (Blueprint $table) {
            $table->id();
            $table->string('server_id');
            $table->string('project_id')->nullable();
            $table->string('comp_id')->nullable();
            $table->string('start_date')->nullable();
            $table->string('emp_id')->nullable();
            $table->string('p_loc')->nullable();
            $table->string('p_city')->nullable();
            $table->string('image')->nullable();
            $table->string('marla_sqf')->nullable();
            $table->string('sales_project_id')->nullable();
            $table->string('hr_project_cgs')->nullable();
            $table->string('wip_project_id')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('housing_projects');
    }
};
