<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleDeedMain extends Model
{
    use HasFactory;
    
    public $table = 'Housing_Sale_Deed_Main';

    public function getdateAttribute($date)
    {
        return Carbon::parse($date)->toDateString();
    }

    protected function scopewhereCustomer($query , $id)
    {
        if (!is_null($id)) {
            return $query->where('csparty.id' , $id);
        }
    }

    public function installments()
    {
        return $this->hasMany(Housing_Sale_Inst_Pay_Main::class, 'UP_ID', 'UP_ID');
    }

    public function paidInstallments()
    {
        return $this->installments()->where('Inst_Amt', '>', 0);
    }
}
