<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LedgerMain extends Model
{
    use HasFactory;

    protected $guarded = [];
     protected $table = 'Ledger_Main';

    public $timestamps = false;

    protected function scopewhereId($query , $id)
    {
        if (!is_null($id)) {
            return $query->where('ledger_mains.Ledger_ID',$id) ;
        }
    }

    protected function scopeWhereServerId($query , $serverId)
    {
        if (!is_null($serverId[0])) {
            return $query->whereIn('ledger_mains.server_id',$serverId) ;
        }
    }

    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
        if (!is_null($updateStatus)) {
            return $query->where('ledger_mains.updated_status',$updateStatus) ;
        }
    }
}