<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HousingChargesSchedule extends Model
{
    use HasFactory;


    protected $table = 'housing_charges_schedule';
    protected $guarded = [];

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('housing_charges_schedule.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId))
        {
            return $query->whereIn('housing_charges_schedule.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('housing_charges_schedule.updated_status',$updateStatus) ;

      }
    }

    
}