<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class CsParty extends Model
{
    use HasFactory, HasApiTokens, Notifiable , Authenticatable;
    
    public $table = 'CSParty';
    public $timestamps = false;
    protected $primaryKey = 'ID';
    public $incrementing = true;
    protected $keyType = 'int';
    protected $guarded = [];

    // Accessor to map lowercase 'id' to 'ID'
    public function getIdAttribute()
    {
        return $this->attributes['ID'];
    }

    protected function scopeWhereId($query, $id)
    {
        if ($id !== null) {
            return $query->where('csparty.id', $id);
        }
        return $query;
    }

    protected function scopeWhereUpdateStatus($query, $UpdateStatus)
    {
        if ($UpdateStatus !== null) {
            return $query->where('csparty.updated_status', $UpdateStatus);
        }
        return $query;
    }

    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('csparty.server_id',$serverId) ;
        }
    }

    public function getCreatedAtAttribute()
    {
        return Carbon::parse($this->attributes['created_at'])->format('Y-m-d');
    }

    protected $hidden= ['Cust_Pic','Cust_Thumb_Imp'];
    
    public function account()
    {
        return $this->hasOne(Account::class, 'Acco_LID', 'Cust_No');
    }
}