<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;
    protected $table ="companies";
    protected $guarded = [];

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('companies.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('companies.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('companies.updated_status',$updateStatus) ;

      }
    }
}