<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PlotRecordResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "plot" => $this->plot,
            "marla" => round($this->marla, 2),
            "width" => round($this->width, 2),
            "length" => round($this->length, 2),
            "location" => $this->location,
            "total_price" => $this->total_price,
            "remaining_amount" => $this->remaining_amount,
            "total_paid" => $this->total_paid,
        ];
    }
}