<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentIndexResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'client_id' => $this->csparty_id,
            'client_name' => $this->client->Cust_Name ?? null,
            'client_cnic' => $this->client->NIC_No ?? null,
            'csparty_id' => $this->csparty_id,
            'up_id' => $this->up_id,
            'project_id' => $this->project_id,
            'hsd_id' => $this->hsd_id,
            'plot_id' => $this->plot_id,
            'amount' => number_format($this->amount),
            'transaction_id' => $this->transaction_id,
            'payment_mod' => $this->payment_mod,
            'transaction_date' => Carbon::parse($this->transaction_date)->format('d M Y'),
            'transaction_category' => $this->transaction_category,
            'description' => $this->description,
            'due_date' => Carbon::parse($this->due_date)->format('d M Y'),
            'is_refunded' => $this->is_refunded,
            'is_updatable' => $this->is_updateable,

        ];
    }
}