<?php

namespace App\Http\Resources;

use App\Traits\PlotCategoryColorTrait;
use Illuminate\Http\Resources\Json\JsonResource;

class HousingUnitPlotResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    use PlotCategoryColorTrait;
    public function toArray($request)
    {

        $area = $this->U_W * $this->U_L;
        $price = $this->price;
        $marla = $this->UP_Marla;
        $totalPrice = $price * $marla;
        
        $priceTotal = ($price / 272) * $area;


        return [

            'id' => $this->id,
            'category' => $this->HUP_Name,
            'cat_color' => $this->getCategoryColor($this->HUP_Name,$this->plot_status),
            'price' => number_format($this->price),
            'plot_no' => $this->plot_name,
            'plot_name' => $this->plot_name,
            'up_id' => $this->UP_ID,
            'marla' => $marla,
            'ud_f' => round($this->UD_F, 2),
            'ud_b' => round($this->UD_B, 2),
            'ud_l' => round($this->UD_L, 2),
            'ud_r' => round($this->UD_L, 2),
            'width' => round($this->U_W, 2),
            'length' => round($this->U_L, 2),
            'city' => $this->p_city,
            'project_id' => $this->Project_ID,
            'location' => $this->p_loc,
            'total_price' => $totalPrice,
            'plot_status' => $this->plot_status
           

        ];
    }
}