<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HousingUnitPlotReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
             
            'id' => $this->id,
            'price' => number_format($this->price),
            'company' => $this->company,
            'project' => $this->project,
            'category' => $this->category,
            'ud_f' =>  round($this->UD_F, 2),
            'ud_b' =>  round($this->UD_B, 2),
            'ud_l' =>  round($this->UD_L, 2),
            'ud_r' =>  round($this->UD_R, 2),
            'width' =>  round($this->width, 2),
            'length' =>  round($this->length, 2),
            'up_marla' => round($this->UP_Marla, 2),
            'up_sys_marla' => round($this->UPSys_Marla, 2),
            'status' => $this->status,
            'size_type' => $this->Size_Type,
            'up_type' => $this->UP_Type,
            'covered_area' => round($this->Covered_Area, 2),
            'premium_unit' => $this->premium_unit,
            
        ];
    }
}