<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        if ($this->isMethod('post')) {
            return $this->RulesForPost();
        }else if($this->isMethod('put'))
        {
          return $this->RulesForPut();
        }
        return [
        ];
       
    }
    public function RulesForPost()
    {
        return[
            'email'=>'required|exists:users,email',
            'password'=>'required',
        ];
    }
    public function RulesForPut()
    {
        return [
            'id'=>'required',
            'name'=>'required',
            'type'=>'required|in:products,expenses',
            // 'description'=>'required|max:500',
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success'   => false,
            'message'   => 'Validation errors',
            'data'      => $validator->errors()
        ],422));
    }
   
}
