<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;

class OtpRequest extends FormRequest
{
    protected function failedValidation(Validator $validator)
    {
        throw new ValidationException($validator, $this->validationError($validator));
    }

    protected function validationError(Validator $validator)
    {
        return response()->json([
            'success' => false,
            'message' => 'Validation errors',
            'errors' => $validator->errors()
        ], 422);
    }

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        if ($this->getMethod() == "PUT") {
            return [
                 'otp' => 'required',
                 'customer_id' => 'required'
            ];
        }
        if ($this->getMethod() == "POST") {
            return [
                'csparty_id' => 'required',
                'cell_no' => 'required',
            ];
        }

        return [];
    }
}
