<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\TokenChill;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TokenChillCOntroller extends Controller
{
    use ApiResponseTrait;


    public function store(Request $request)
    {
        $stored = TokenChill::insert($request->all());
        return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = TokenChill::find($request->id);

        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);


        $request->merge(['updated_status' => '1']);
        $record->update($request->all());


        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }
    protected function index(Request $request, $id = null)
    {
        $limit = $request->input('limit', 25);

        $data = TokenChill::whereId($id)
            ->whereUpdateAble($request->updated_status)
            ->Where('Comp_ID', COMPANY_ID)
            ->paginate($limit);

        return $data ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }
    public function serverId()
    {
        $data = TokenChill::select('server_id as id')->Where('Comp_ID', COMPANY_ID)->get();
        return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = DB::table('token_chills')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        foreach ($request->data as $list) {
            $result = DB::table('token_chills')
                ->where('server_id', $list['server_id'])
                ->update([
                    'server_id' => $list['Token_ID'],
                    'Token_ID' => $list['Token_ID'],
                    'Comp_ID' => $list['Comp_ID'],
                    'Project_ID' => $list['Project_ID'],
                    'Project_ID_REFRENCE' => $list['Project_ID_REFRENCE'],
                    'UP_ID' => $list['UP_ID'],
                    'UP_ID_REFRENCE' => $list['UP_ID_REFRENCE'],
                    'L_Remarks' => $list['L_Remarks']
                ]);

            if ($result !== false) 
                $successCount++;
            
        }
        return $successCount === $totalCount ? $this->successUpdateResponse("All records updated successfully.") : $this->errorUpdateResponse("Failed to update some records.");
    }
}
