<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Newz;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NewzController extends Controller
{
    public function store(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'text' => 'required',
            'img' => 'required|image',
            'date' => 'required'
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }
    
      
        $newz = new Newz();
        $newz->title = $request->title;
        $newz->text = $request->text;
        $newz->position = 1;
        $newz->created_at = $request->date;
    
        if ($request->hasFile('img')) {
            $img_1 = $request->file('img');
            $imageName_1 = uniqid('img').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('newz-images'), $imageName_1);
            $newz->img= url('public/newz-images/'.$imageName_1);
        }

        if($newz->save())
        {
            return response()->json([
                'message' => 'record created successfully'
            ],201);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    
       
    }

    public function get(Request $request , $id = null)
    {
        $status = is_null($request->status) ? "deleted" : $request->status;

        $data = Newz::orderBy('position' , 'asc');
        if($status  == "deleted")
        {
            $data = $data->where('status' , '<>' ,'deleted');
        }else{
            $data  = $data->where('status' , $data);
        }
        if(!is_null($id))
        {
            $data = $data->where('id' , $id);
        }
        $data = $data->get();

        if($data->isNotEmpty())
        {
             return response()->json([
                'data' => $data
             ],200);
        }else{
            return response()->json([
               'message' => 'no record found !'
            ],404);
        }        
    }

    public function update(Request $request , $id)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'text' => 'required',
            'img' => 'nullable|image',
            'date' => 'required'
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }

        $newz = Newz::find($id);

        if(!$newz)
        {
            return response()->json([
                'message' => 'no record found !'
            ],404);
        }

        $newz->title = $request->title;
        $newz->text = $request->text;
        $newz->created_at = $request->date;
    
        if ($request->hasFile('img')) {
            $img_1 = $request->file('img');
            $imageName_1 = uniqid('img').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('newz-images'), $imageName_1);
            $newz->img= url('public/newz-images/'.$imageName_1);
        }

        if($newz->save())
        {
            return response()->json([
                'message' => 'record updated successfully'
            ],201);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    }

    public function changeStatus($id , $status)
    {
        $newz = Newz::find($id);
        if(!$newz){
            return response()->json([
               'message' => 'no record found !'
            ],404);
        }

        $validStatuses = ['active', 'inactive', 'deleted'];
        if (!in_array($status, $validStatuses)) {
            return response()->json([
                'message' => 'Invalid status'
            ], 422);
        }

        $newz->status = $status;
        if($newz->save())
        {
            return response()->json([
                'message' => 'change status successfully'
            ],200);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    }

    public function uploadImage(Request $request)
    {
       $validation = Validator::make($request->all(),[
           'img' => 'required|image',
       ]);
       if($validation->fails())
       {
         return response()->json([
             'message' => 'validation failed',
             'errors' => $validation->errors(),
         ],422);
       }

    }
}
