<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Account;
use App\Models\LedgerMain;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerMainController extends Controller
{
    use ApiResponseTrait;
   
    
    public function store(Request $request)
    {
      $stored = LedgerMain::insert($request->all());
      return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = LedgerMain::find($request->id);
        if(!$record)  return $this->generalResponse('RECORD_NOT_FOUND', 404);
        
        $updatedStatus = [
            'updated_status' => '1',
        ];
        $request->merge($updatedStatus);
        $record->update($request->all());
        if ($record)
           return $this->successUpdateResponse($record);
        else
           return $this->errorUpdateResponse();
    }
    protected function index(Request $request , $id = null )
    {

        $serverId[] = $request->server_id;
        $limit = $request->input('limit', 25);
        $data = LedgerMain::whereId($id)
        ->whereServerId($serverId)
        ->Where('Comp_ID', COMPANY_ID)
        ->whereUpdateAble($request->updated_status)
        ->paginate($limit);
        if ($data)
           return $this->recordFoundResponse($data);
        else
            return $this->recordNotFoundResponse();
    }
    public function serverId()
    {
      $data = LedgerMain::select('server_id as id')->Where('Comp_ID', COMPANY_ID)
      ->get();
      return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
       $serverIds= $request->server_id;
       $execute = DB::table('ledger_mains')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        if ($execute)
            return $this->successUpdateResponse($serverIds);
         else
            return $this->errorUpdateResponse();
         
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        foreach ($request->data as $list) {

            
            $result = DB::table('ledger_mains')
                        ->where('server_id', $list['server_id'])
                        ->update([
                            'Ledger_ID' => $list['server_id'],
                            'Comp_ID' => $list['Comp_ID'],
                            'Acco_LID' => $list['Acco_LID'],
                            'BT_No' => $list['BT_No'],
                            'L_Date' => $list['L_Date'],
                            'L_Amount' => $list['L_Amount'],
                            'Descr' => $list['Descr'],
                            'Per_ID' => $list['Per_ID'],
                            'User_ID' => $list['User_ID'],
                            
                        ]);
           
            if ($result !== false) { // Check if update was successful
                $successCount++;
            }
        }
    
        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
    public function addToSql(Request $request)
    {
        $server_ids = explode(',', $request->server_id);
        $data = LedgerMain::whereNotIn('server_id', $server_ids)->Where('Comp_ID', COMPANY_ID)->get();
        return $data;
    }
}
