<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\LedgerDetail;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerDetailController extends Controller
{
    use ApiResponseTrait;


    public function store(Request $request)
    {

        $stored = LedgerDetail::insert($request->all());
        return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();

    }


    protected function update(Request $request)
    {
        $record = LedgerDetail::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);
        
        $request->merge(['updated_status' => '1']);
        $record->update($request->all());

        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }
    
    protected function index(Request $request, $id = null)
    {

        $serverId[] = $request->server_id;
        $limit = $request->input('limit', 25);
        $data = LedgerDetail::whereId($id)
            ->whereServerId($serverId)
            ->Where('Comp_ID', COMPANY_ID)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);
        if ($data)
            return $this->recordFoundResponse($data);
        else
            return $this->recordNotFoundResponse();
    }
    public function serverId()
    {
        $data = LedgerDetail::select('server_id as id')->Where('Comp_ID', COMPANY_ID)
            ->get();
        return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = DB::table('ledger_details')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        if ($execute)
            return $this->successUpdateResponse($serverIds);
        else
            return $this->errorUpdateResponse();

    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        //  dd($request->data);

        foreach ($request->data as $list) {

            $result = DB::table('ledger_details')
                ->where('server_id', $list['server_id'])
                ->update([
                    'Ledger_ID' => $list['Ledger_ID'],
                    'Comp_ID' => $list['Comp_ID'],
                    'BT_No' => $list['BT_No'],
                    'Acco_LID' => $list['Acco_LID'],
                    'R_Acco_LID' => $list['R_Acco_LID'],
                    'Debit' => $list['Debit'],
                    'Credit' => $list['Credit'],
                    'L_Remarks' => $list['L_Remarks'],
                    'L_QTY' => $list['L_QTY'],
                    'Accrual_Date' => $list['Accrual_Date']

                ]);

            if ($result !== false) { // Check if update was successful
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }

    }
    public function addToSql(Request $request)
    {
        $server_ids = explode(',', $request->server_id);
        $data = LedgerDetail::whereNotIn('server_id', $server_ids) ->Where('Comp_ID', COMPANY_ID)->get();
        return $data;
    }
    
}
