<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\HousingUnitPremium;
use App\Models\SubCategory;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HousingUnitPremiumController extends Controller
{
    use ApiResponseTrait;

    public function store(Request $request)
    {
        $stored = HousingUnitPremium::insert($request->all());
        if ($stored)
            return $this->successInsertResponse($stored);
        else
            return $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = SubCategory::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);

        $request->merge(['updated_status' => '1']);
        $record->update($request->all());

        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }
    protected function index(Request $request, $id = null)
    {
        $serverId[] = $request->server_id;
        $limit = $request->input('limit', DEFAULT_LIMIT);
        $data = HousingUnitPremium::whereId($id)
            ->whereServerId($serverId)
            ->Where('Comp_ID', COMPANY_ID)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);

        return ($data->total() > 0) ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }

    public function serverId()
    {
        $data = HousingUnitPremium::select('server_id as id')->Where('Comp_ID', COMPANY_ID)->get();

        return $data->isNotEmpty()
            ? $this->successResponse($data, RECORD_FOUND, HTTP_OK)
            : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);

    }
    
    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = HousingUnitPremium::whereIn('server_id', $serverIds)->update(['updated_status' => '0']);
        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();

    }
    
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        foreach ($request->data as $list) {
            $result = DB::table('housing_unit_premiums')
                ->where('server_id', $list['server_id'])
                ->update([
                    'comp_id' => $list['comp_id'],
                    'hup_name' => $list['hup_name'],
                    'remarks' => $list['remarks'],
                    'b_group' => $list['b_group'],
                ]);

            if ($result !== false)
                $successCount++;
        }

        if ($successCount === $totalCount)  
            return $this->successUpdateResponse("All records updated successfully.");
        else
            return $this->errorUpdateResponse("Failed to update some records.");
        
    }



    public function premiumList()
    {
        $data = HousingUnitPremium::select('HUP_ID as id', 'HUP_Name as category')->get();
        if (!$data->isEmpty()) {
            $response = [
                "message" => "Record found.",
                "data" => $data,
                "query" => null
            ];
        } else {
            $response = [
                "message" => "No records found.",
                "data" => [],
                "query" => null
            ];
      }

      return response()->json($response);
    
    }
    
}
