<?php

namespace App\Http\Controllers\V1\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\OtpRequest;
use App\Mail\MailForgetPassword;
use App\Mail\WelcomeEmail;
use App\Models\Account;
use App\Models\CsParty;
use App\Models\Otp;
use App\Models\Payment;
use Illuminate\Http\Request;
use App\Traits\ApiResponseTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Exception;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Log;

class CsPartyAuthController extends Controller
{
    use ApiResponseTrait; 

    public function upload(Request $request)
    {

        $request->validate(['pdf' => 'required|mimes:pdf|max:2048']);

        $filePath = $request->file('pdf')->store('pdf', 'public');
        $downloadLink = Storage::url($filePath);
        $fullUrl = "http://canalpalms-apis.sparksolutionz.com$downloadLink";



        $payload = [
            "messaging_product" => "whatsapp",
            "recipient_type" => "individual",
            "to" => '923157351313',
            "type" => "document",
            "document" => [
                "link" => $fullUrl
            ]
        ];



        $version = 'v12.0';
        $phoneNumberId = "370526819468308";
        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";

        $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
            ->post($url, $payload);

        if ($response->successful()) {
            return response()->json([
                'message' => 'PDF uploaded and sent via WhatsApp successfully!',
                'link' => $fullUrl,
                'response' => $response,
            ]);
        } else {
            return response()->json([
                'message' => 'Failed to send the document via WhatsApp!',
                'error' => $response->json()
            ], $response->status());
        }
    }

    
    protected function login(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'cnic' => 'nullable',
            'password' => 'required',
            'email' => 'nullable'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }

        $user = CsParty::where('status', 'active')
            ->when($request->email, function ($query) use ($request) {
                $query->where('E_Mail', $request->email);
            }, function ($query) use ($request) {
                $query->where('NIC_No', $request->cnic)
                    ->orWhere('E_Mail', $request->cnic);
            })
            ->first();

             if (!$user || $user->password !== $request->password) {
                return response()->json([
                    'message' => 'Invalid Credentials'
                ], 401);
            }
            

       

        $token = $user->createToken($user->Cust_Name . '-AuthToken')->plainTextToken;

        return response()->json([
            'message' => 'Login Success Fully',
            'access_token' => $token,
            'user' => collect($user->toArray())->map(function ($value) {
                return is_string($value) ? utf8_encode($value) : $value;
            }),
            'id' => $user->ID,
            'role' => $user->role,
            'name' => $user->Cust_Name,
            'cnic' => $user->NIC_No,
            'email' => $user->E_Mail,
            // 'image' => $user->Cust_Pic
            'account' => $user->account,
        ],200);
        
       
    }


    // public function logout()
    // {
    //     $user = auth()->user();

    //     if ($user) {
    //         $result = $user->tokens()->delete();

    //         if ($result) {
    //             return response()->json([
    //                 'message' => 'Logout successfully',
    //             ], 200);
    //         } else {
    //             return response()->json([
    //                 'message' => 'Something went wrong, try again!',
    //             ], 422);
    //         }
    //     } else {
    //         return response()->json([
    //             'message' => 'No authenticated user found',
    //         ], 401);
    //     }
    // }




    

  


  

    public function addCustomerOld(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name' => [
                'required',
                function ($attribute, $value, $fail) {
                    $existsInAccounts = DB::table('Account')
                        ->where('Alias_Name', $value)
                        ->exists();

                    $existsInCSParty = DB::table('CSParty')
                        ->where('Cust_Name', $value)
                        ->exists();

                    // Fail if found in ANY of the tables
                    if ($existsInAccounts || $existsInCSParty) {
                        $fail("The {$attribute} already exists as customer name .");
                    }
                },
            ],
            'cnic' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors()
            ], 422);
        }




        try {
            DB::beginTransaction();
            $newCustNo = '2000.1.1.2.1';
            $lastEntry = Account::where('Comp_ID', 16)
                ->where('Acco_LID', 'like', '2000.1.1.2.%')
                ->orderBy('Acco_LID', 'desc')
                ->first();
                
                return $lastEntry;

            if ($lastEntry) {
                $custNo = $lastEntry->Acco_LID;  
                $custNoParts = explode('.', $custNo);
                $lastPart = (int) array_pop($custNoParts); 
                $newLastPart = $lastPart + 1;
                $newCustNo = implode('.', $custNoParts) . '.' . $newLastPart;
            }        

            function generatePassword($length = 8) {
                $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                $password = '';
                $maxIndex = strlen($characters) - 1;

                for ($i = 0; $i < $length; $i++) {
                    $password .= $characters[random_int(0, $maxIndex)];
                }

                return $password;
            }

            $password = generatePassword(8);

            // Create New Account
            $account = Account::create([
                'Acco_ID' => (Account::max('Acco_ID') ?? 0) + 1,
                'Acco_LID' => $newCustNo,
                'CAcco_ID' => '2000.1.1.2',
                'Comp_ID' => 16,
                'User_ID' => 1000,
                'Alias_Name' => $request->input('name'),
                'Acco_Name' => $request->input('name'),
                'Status' => 'Yes',
                'Acco_Leve1' => '1',
                'Sys_Acco' => 'Yes',
                'Child_Acco' => 'NO',
                'Created_On' => now(),
                'Edited_By' => 0,
                'Comp_ID_All' => 0,
                'B_Group' => 'HOUSING',
                'Veh_Acco' => 'YES',
                'Accrual_Acco' => 'NO',
            ]);

            $csParty = CsParty::create([
                'ID' => (CsParty::max('ID') ?? 0) + 1,
                'Comp_ID' => 16,
                'Cust_NO' => $newCustNo,
                'Cust_Name' => $request->input('name'),
                'NIC_No' => $request->input('cnic'),
                'E_Mail' => $request->input('email'),
                'Phon1' => $request->input('whatsapp_number'),
                'Password' => $password,
                'Ledger_ID' => 0,
                'AA_ID' => 0,
                'SA_ID' => 0,
                'AD_ID' => 0,
                'City_ID' => 0,
                'Disc_Per' => 0,
                'Sale_Price' => 0,
                'Open_Bala' => 0,
                'Cust_Supp_Int' => 0,
            ]);
            $cust = (CsParty::max('ID') ?? 0);

            $data = [
                'id' => $cust,
                'password' => $password
            ];

            $this->createOtp($request->input('whatsapp_number'), $cust);

            DB::commit();
            return $this->successInsertResponse($data);
        } catch (\Exception $e) {
            DB::rollBack();
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
            //return $this->errorInsertResponse();
        }
    }
      public function addCustomer(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name' => [
                'required',
                function ($attribute, $value, $fail) {
                    $existsInAccounts = DB::table('Account')
                        ->where('Alias_Name', $value)
                        ->exists();

                    $existsInCSParty = DB::table('CSParty')
                        ->where('Cust_Name', $value)
                        ->exists();

                    // Fail if found in ANY of the tables
                    if ($existsInAccounts || $existsInCSParty) {
                        $fail("The {$attribute} already exists as customer name .");
                    }
                },
            ],
            'cnic' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors()
            ], 422);
        }




        try {
            DB::beginTransaction();
            $newCustNo = '2000.1.1.2.1';
           $lastEntry = Account::where('Acco_LID', 'like', '2000.1.1.2.%')
            ->orderByRaw("CAST(RIGHT(Acco_LID, CHARINDEX('.', REVERSE(Acco_LID)) - 1) AS INT) DESC")
            ->first();
            


            if ($lastEntry) {
                $custNo = $lastEntry->Acco_LID;  
                $custNoParts = explode('.', $custNo);
                $lastPart = (int) array_pop($custNoParts); 
                $newLastPart = $lastPart + 1;
                $newCustNo = implode('.', $custNoParts) . '.' . $newLastPart;
            }   
            
            // return $newCustNo;

            function generatePassword($length = 8) {
                $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                $password = '';
                $maxIndex = strlen($characters) - 1;

                for ($i = 0; $i < $length; $i++) {
                    $password .= $characters[random_int(0, $maxIndex)];
                }

                return $password;
            }

            $password = generatePassword(8);

            // Create New Account
            $account = Account::create([
                'Acco_ID' => (Account::max('Acco_ID') ?? 0) + 1,
                'Acco_LID' => $newCustNo,
                'CAcco_ID' => '2000.1.1.2',
                'Comp_ID' => 16,
                'User_ID' => 1000,
                'Alias_Name' => $request->input('name'),
                'Acco_Name' => $request->input('name'),
                'Acco_Clas' => "",
                'Sub_Clas' => "",
                'Acco_Leve' => "",
                'Status' => 'Yes',
                'Acco_Leve1' => '1',
                'Sys_Acco' => 'Yes',
                'Child_Acco' => 'NO',
                'Created_On' => now(),
                'Edited_By' => 0,
                'Remarks' => '',
                'Edited_On' => 0,
                'Comp_ID_All' => 0,
                'B_Group' => 'HOUSING',
                'Veh_Acco' => 'YES',
                'Accrual_Acco' => 'NO',
            ]);

            $csParty = CsParty::create([
                'ID' => (CsParty::max('ID') ?? 0) + 1,
                'Comp_ID' => 16,
                'Cust_NO' => $newCustNo,
                'Cust_Name' => $request->input('name'),
                'Sale_TaxNo' => "",
                'NTN_No' => "",
                'Addr1' => "",
                'Addr2' => "",
                'Mobi' => "",
                'Fax' => "",
                'Comp' => "",
                'Contact_Person' => "",
                'Sale_Person_ID' => "",
                'Bank_Name' => "",
                'Bank_Acco_Title' => "",
                'Bank_Acco_No' => "",
                'Cust_Thumb_Imp' => null,
                'Credit_Limit' => 0,
                'Credit_Days' => 0,
                'NIC_No' => $request->input('cnic'),
                'E_Mail' => $request->input('email'),
                'Phon1' => $request->input('whatsapp_number'),
                'Password' => $password,
                'Ledger_ID' => 0,
                'AA_ID' => 0,
                'SA_ID' => 0,
                'AD_ID' => 0,
                'City_ID' => 0,
                'Disc_Per' => 0,
                'Sale_Price' => 0,
                'Open_Bala' => 0,
                'Cust_Supp_Int' => 0,
                'Cust_Pic' => null,
            ]);
            $cust = (CsParty::max('ID') ?? 0);

            $data = [
                'id' => $cust,
                'password' => $password
            ];

            $this->createOtp($request->input('whatsapp_number'), $cust);

            DB::commit();
            return $this->successInsertResponse($data);
        } catch (\Exception $e) {
            DB::rollBack();
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
            //return $this->errorInsertResponse();
        }
    }

    public function changePassword(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'current_password' => 'required',
            'new_password' => 'required',
        ]);
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ]);
        }

        $customer = CsParty::find(Auth::user()->id);
        if (Hash::check($request->current_password, $customer->password)) {
            $customer->password = Hash::make($request->new_password);
            if ($customer->save()) {
                return response()->json([
                    'message' => 'password change successfully',
                ], 200);
            }
        } else {
            return response()->json([
                'message' => 'invalid current password!',
            ], 404);
        }
    }

  
    public function verifyOtp(OtpRequest $request)
    {
        $validation = Validator::make($request->all(), [
            'otp' => 'required',
            'customer_id' => 'required'
        ]);

        // |exists:csparty,id
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ]);
        }

        $otpData = Otp::where('csparty_id', $request->input('customer_id'))
            ->where('otp', $request->input('otp'))
            ->orderBy('ID', 'desc')
            ->first();

        if (!$otpData) {
            return response()->json([
                'message' => 'no otp exist'
            ], 400);
        }

        $date = $otpData->expires_at->toDateString();
        //$expireTime = Carbon::parse($otpData['created_at'])->timezone('Asia/Karachi')->addMinutes(10)->toTimeString();
        $expireTime = Carbon::parse($otpData['expires_at'])->toTimeString();

        if ($date == date('Y-m-d')) {
            $currentTime = Carbon::now()->timezone('Asia/Karachi')->toTimeString();
            if ($currentTime <= $expireTime) {
                $customer = CsParty::find($otpData['csparty_id']);
                $customer->verified_at = Carbon::now();
                $status = '';

                // try {
                //     Mail::to($customer->E_Mail)->send(new WelcomeEmail($customer, $request->password, $customer->NIC_No));

                //   $email = "Passed";
                // } catch (\Exception $e) {
                //     // return response()->json([
                //     //     'message' => 'Customer created, but failed to send welcome email.',
                //     //     'error' => $e->getMessage(),
                //     //     'mail' => $customer->E_Mail,
                //     // ], 500);
                //     $email = "failed";
                // }
                try {
                    $version = 'v12.0';
                    $phoneNumberId = "370526819468308";
                    $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";
                    $cellNumber = $customer->Phon1;
                    
                    $payload = [
                        'messaging_product' => 'whatsapp',
                        'to' => $cellNumber,
                        'type' => 'template',
                        'template' => [
                            'name' => 'login_details',
                            'language' => [
                                'code' => 'en_US',
                            ],
                            'components' => [
                                [
                                    'type' => 'body',
                                    'parameters' => [
                                        [
                                            'type' => 'text',
                                            'text' => $customer->Cust_Name,
                                        ],
                                        [
                                            'type' => 'text',
                                            'text' => $customer->E_Mail ,
                                        ],
                                        [
                                            'type' => 'text',
                                            'text' => $customer->password,
                                        ]
                                        
                                    ],
                                ],
                            
                            ],
                        ],
                    ];
            
                    $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
                    ->post($url, $payload);
                    $status = $response->status();

                    $customer->save();
                    $otpData->delete();

                    return response()->json([
                        'message' => 'Otp Verified',
                        'status' => $status,'body' => $response->body(),
                        // 'email' => $email,
                        //    'currentTime' => $currentTime,
                        //    'expiredTime' => $expireTime,
                    ], 200);
                } catch(\Exception $e) {
                    return response()->json([
                        'message' => $e->getMessage(),
                    ], 400);
                }
            } else {
                return response()->json([
                    'message' => 'invalid otp or expired',
                ], 400);
            }
        } else {
            return response()->json([
                'message' => 'invalid otp or expired',
            ], 400);
        }
    }

    public function sendOpt(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'csparty_id' => 'required|integer',
            'cell_no' => 'required',
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ]);
        }

        $isSent = $this->createOtp($request->cell_no, $request->csparty_id);

        if ($isSent)
            return response([
                'message' => "OTP sent successfully"
            ], 200);

        return response([
            'message' => "Something went wrong please try agin"
        ], 501);
    }

    public function changePhoneNo(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'customer_id' => 'required|integer',
            'phone_number' => 'required',
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors()
            ], 422);
        }

        $customer = CsParty::find($request->customer_id);
        if (!empty($customer)) {
            if (!is_null($customer->verified_at)) {
                return response()->json([
                    'message' => 'user already verified , try login'
                ], 409);
            }

            $customer->Phon1 = $request->phone_number;
            if ($customer->save()) {
                return $this->createOtp($request->phone_number, $request->customer_id);
            }
        } else {
            return response()->json([
                'message' => 'invalid user',
            ], 409);
        }
    }

    private function createOtp($cellNumber, $csPartyId)
    {
        $otp = random_int(1000, 9999);
        $version = 'v12.0';
        $phoneNumberId = "370526819468308";
        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";


        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $cellNumber,
            'type' => 'template',
            'template' => [
                'name' => 'otp',
                'language' => [
                    'code' => 'en',
                ],
                'components' => [
                    [
                        'type' => 'body',
                        'parameters' => [
                            [
                                'type' => 'text',
                                'text' => $otp,
                            ],
                        ],
                    ],
                    [
                        'type' => 'button',
                        'sub_type' => 'url',
                        'index' => 0,
                        'parameters' => [
                            [
                                'type' => 'text',
                                'text' => '1234567',
                            ],
                        ],
                    ],
                ],
            ],
        ];


       
        $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
            ->post($url, $payload);

        $status = $response->status();
        if ($status == 400) {
            return response()->json([
                'message' => 'invalid whatsapp number!',
                'user_id' => $csPartyId
            ], $status);
        }


        if ($response->successful()) {

            Otp::create([
                'csparty_id' => $csPartyId,
                'otp' => $otp,
                'expires_at' => now()->addMinutes(10)->toDateTimeString()
            ]);


        }

        return $status;

    }
   

    protected function delete($id)
    {        
        if ($csParty = CsParty::find($id)) {
            try {
                $csParty->status = 'deleted';
                return $csParty->save() ? $this->successDeleteResponse() : $this->errorDeleteResponse();                
            } catch (Exception $e) {
                // Log::error("Error deleting CsParty record with id $id: " . $e->getMessage());
                return $this->errorDeleteResponse();
            }
        }

        return $this->recordNotFoundResponse();
    }

    public function ForgetPassword(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'email' => 'nullable'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'errors' => $validation->errors()
            ], 422);
        }

        if(is_null($request->email) && is_null($request->whatsapp_number))
        {
            return response()->json([
               'message' => 'Please provide either your email or WhatsApp number.'
            ],422);
        }

        $query = CsParty::query();

        if ($request->email) {
            $query->where('E_Mail', $request->email)->whereNotNull('E_Mail');
        }

        if ($request->whatsapp_number) {
            $query->orWhere('Phon1', $request->whatsapp_number)->whereNotNull('Phon1');
        }

        $user = $query->first();

        //    return $user;
        if ($user) {
            $recipientEmail = $request->email;
            $recipientWhatsapp = $request->whatsapp_number;

            $id = $user->id + 500000;
            $encryptedEmail = Crypt::encryptString($recipientEmail);
            $encryptedWhatsapp = Crypt::encryptString($recipientWhatsapp);
            $encryptedId = Crypt::encryptString($id);

            

            if(!is_null($recipientEmail))
            {
                // try{
                  $emailData = ['email' => $recipientEmail, 'user_name' => $user->Cust_Name, 'token' => $encryptedEmail . '(_)' . $encryptedId];
                  Mail::to($recipientEmail)->send(new MailForgetPassword($emailData));
                  $email = 'success';

                // }catch(\Exception $e)
                // {
                //   $email = 'failed';
                // }
            }else{
                $email = 'not found!';
            }
            if(!is_null($recipientWhatsapp))
            {
                // return Crypt::decryptString($encryptedId);

                  try{
                           $version = 'v12.0';
                            $phoneNumberId = "370526819468308";
                            $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";
                            $cellNumber = $recipientWhatsapp;
                    
                    
                            $payload = [
                                'messaging_product' => 'whatsapp',
                                'to' => $cellNumber,
                                'type' => 'template',
                                'template' => [
                                    'name' => 'reset_pass',
                                    'language' => [
                                        'code' => 'en',
                                    ],
                                    'components' => [
                                        [
                                            'type' => 'body',
                                            'parameters' => [
                                                [
                                                    'type' => 'text',
                                                    'text' => 'https://canalpalms.com/reset-password/'.$encryptedWhatsapp . '(_)' . $encryptedId ,
                                                ],
                                                
                                                
                                            ],
                                        ],
                                    
                                    ],
                                ],
                            ];
                    
                            $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
                            ->post($url, $payload);
                            $status = $response->status();
                            $whatsApp = 'success';
                            
                }catch(\Exception)
                {
                   $whatsApp = 'failed ';
                }
            }else{
                $whatsApp = 'number not found !';
            }
                          
                return response()->json([
                    'success' => true,
                    'email' => $email,
                    'whatsapp' => $whatsApp,
                    // 'whatsapp_response' => $response->body(),
                    'message' => 'Password reset link sent to your given account.',
                ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'invalid data',
                
            ], 409);
        }

    }
    public function ResetPassword(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'token' => 'required',
            'password' => 'required'
        ]);
        if ($validation->fails()) {
            return response()->json([
                'errors' => $validation->errors(),
            ], 422);
        }
        $token = $request->token;
        $explode = explode('(_)', $token);

        if (count($explode) !== 2) {
            return response()->json([
                'message' => 'invalid Link or Expired , try again!',
            ], 409);
        }

        $email = $explode[0];
        $id = $explode[1];

        if (!(Crypt::decryptString($email)) || !(Crypt::decryptString($id))) {
            return response()->json([
                'message' => 'invalid Link or Expired , try again!',
            ], 409);
        } else {
            $decryptEmail = Crypt::decryptString($email);
            $decryptId = Crypt::decryptString($id);
        }


        // return $decryptId - 500000;
        $find = CsParty::find($decryptId - 500000);
        // return $decryptEmail;
        if ($find) {
            if ($find->E_Mail != $decryptEmail && $find->Phon1 != $decryptEmail) {
                return response()->json([
                    'message' => 'invalid Token',
                ], 409);
            }
            $find->password = $request->password;
            if ($find->save()) {
                return response()->json([
                    'message' => 'Password resst successfully',
                ], 200);
            }
        } else {
            return response()->json([
                'message' => 'invalid Token',
            ], 409);
        }


    }

    public function updateProfile(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required',
            'cnic' => 'required',
            'email' => 'required',
            'whatsapp_number' => 'required',
            'image' => 'mimes:jpeg,jpg,png,gif|max:20000'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }
        $path = '';
        $obj = CsParty::find($request->id);
        $obj->Cust_Name = $request->input('name');
        $obj->NIC_No = $request->input('cnic');
        $obj->E_Mail = $request->input('email');
        $obj->whatsapp_number = $request->input('whatsapp_number');
        if ($request->hasFile('image')) {
            $destination = "canalpalms-apis.canalpalms.com//public/profiles/";
            $imageName = time() . '.' . $request->image->extension();
            $path = $destination . $imageName;
            $request->image->move(public_path('profiles'), $path);
        }
        $obj->Cust_Pic = $path;

        if ($obj->save()) {
            return response()->json([
                'success' => true,
                'message' => 'Record update SuccessFully',
                'data' => $obj,
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'fail to update record!',
            ], 400);
        }
    }

    public function fetchTokens(Request $request)
    {
        $validation = Validator::make($request->all(),[
           'id' => 'required',
        ]);
        if($validation->fails())
        {
            return response()->json([
               'message' => 'validation failed !',
               'errors' => $validation->errors(),
            ],422);
        }
        $id = $request->id;

        $token = Payment::where('csparty_id', $id)->where('is_updateable', '1')->where('transaction_category', 'token');
        if(!is_null($request->plot_id))
        {
            $token->where('plot_id' , $request->plot_id);
        }
        $token = $token->get();
        
        if ($token->isNotEmpty()) {
            return response()->json([
                'data' => $token,
            ], 200);
        } else {
            return response()->json([
                'message' => 'no Record Found !',
            ], status: 404);

        }
    }

    public function customerDuplicateNameCheck($name)
    {
        $exists = CsParty::where('Cust_Name', $name)->exists();

        if ($exists) {
            return response()->json([
                'message' => 'Name already exists',
            ], 409);
        }

        return response()->json([
            'message' => 'Name is available',
        ], 200);
    }

    public function duplicateEmailCheck(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'email' => 'required|email'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }

        $exists = CsParty::where('E_mail', $request->input('email'))->exists();

        if ($exists) {
            return response()->json([
                'message' => 'Email already exists!'
            ], 409); 
        }

        return response()->json([
            'message' => 'Email is available.'
        ], 200);
    }
    public function duplicateCnicCheck(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'cnic' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }

        $cnic = $request->input('cnic'); 

        $exists = CsParty::where('NIC_No', $cnic)->exists();

        if ($exists) {
            return response()->json([
                'message' => 'cnic already exists!'
            ], 409); 
        }

        return response()->json([
            'message' => 'cnic is available.'
        ], 200);
    }

    public function duplicatePhoneCheck(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'whatsapp_number' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }

        $whatsappNumber = preg_replace('/[^+\d]/', '', $request->input('whatsapp_number')); 

        $exists = CsParty::get()
            ->pluck('Phon1')
            ->map(function ($num) {
                return preg_replace('/[^+\d]/', '', $num);
            })
            ->contains($whatsappNumber);

        if ($exists) {
            return response()->json([
                'message' => 'whatsapp_number already exists!',
            ], 409); 
        }
        

        return response()->json([
            'message' => 'whatsapp_number is available.'
        ], 200);
    }

    public function checkLogin()
    {
        return response()->json([
            'message' => 'user is login'
        ],200);
    }

    public function deleteAccount(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors' => $validation->errors()
            ], 422);
        }

        $user = CsParty::where('E_Mail', $request->email)->where('status','active')->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json([
                'message' => 'User Does not exist'
            ], 404);
        }

        $user->update(['status' => 'deleted']);

        return response()->json([
            'message' => 'Account deleted successfully'
        ], 200);
    }


}