<?php

namespace App\Http\Controllers;

use App\Models\UnitBlock;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UnitBlockController extends Controller
{
    use ApiResponseTrait;
 
    public function store(Request $request)
    {
      $stored = UnitBlock::insert($request->all());
      
      return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = UnitBlock::find($request->id);
        if(!$record) {
            return $this->generalResponse('RECORD_NOT_FOUND', 404);
        }
        $updatedStatus = [
            'updated_status' => '1',
        ];
        $request->merge($updatedStatus);
        $record->update($request->all());
        if ($record)
           return $this->successUpdateResponse($record);
        else
           return $this->errorUpdateResponse();
    }
    
    protected function index(Request $request , $id = null )
    {
        $serverId[] = $request->server_id;
        $limit = $request->input('limit', DEFAULT_INCLUDE_PATH);
        $data = UnitBlock::whereId($id)
        ->whereServerId($serverId)
        ->whereUpdateAble($request->updated_status)
        ->paginate($limit);
        if ($data)
           return $this->recordFoundResponse($data);
        else
            return $this->recordNotFoundResponse();
    }
    public function serverId()
    {
      $data = UnitBlock::select('server_id as id')
      ->get();
      return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
       $serverIds= $request->server_id;
       $execute = DB::table('unit_blocks')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        if ($execute)
            return $this->successUpdateResponse($serverIds);
         else
            return $this->errorUpdateResponse();
         
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        foreach ($request->data as $list) {
            // return $list;
            // return $list['server_id'];
            $result = DB::table('unit_blocks')
                        ->where('server_id', $list['server_id'])
                        ->update([
                            'comp_id' => $list['Comp_ID'],
                            'hub_name' => $list['HUB_Name'],
                            'remarks' => $list['Remarks'],
                            'b_group' => $list['B_Group'],
                        ]);
           
            if ($result !== false) { 
                $successCount++;
            }
        }
    
        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
}