<?php

namespace App\Http\Controllers;

use App\Models\SubCategory;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SubCategoryController extends Controller
{
    use ApiResponseTrait;
 
    public function store(Request $request)
    {
      $stored = SubCategory::insert($request->all());
      return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = SubCategory::find($request->id);
        if(!$record) {
            return $this->generalResponse('RECORD_NOT_FOUND', 404);
        }

        $request->merge(['updated_status' => '1']);
        $record->update($request->all());
        if ($record)
           return $this->successUpdateResponse($record);
        else
           return $this->errorUpdateResponse();
    }
    
    protected function index(Request $request , $id = null )
    {

        $serverId[] = $request->server_id;
        $limit = $request->input('limit', DEFAULT_LIMIT);
        $data = SubCategory::whereId($id)
        ->whereServerId($serverId)
        ->whereUpdateAble($request->updated_status)
        ->paginate($limit);
        return $data ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
       
    }

    public function serverId()
    {
      $data = SubCategory::select('server_id as id')
      ->get();
      return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }

    public function changeUpdatedStatus(Request $request)
    {
       $serverIds= $request->server_id;
       $execute = DB::table('sub_categories')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        return $execute ?  $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();
         
    }

    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);
        foreach ($request->data as $list) {
            $result = DB::table('sub_categories')
                        ->where('server_id', $list['server_id'])
                        ->update([
                            'comp_id' => $list['Comp_ID'],
                            'husc_name' => $list['HUSC_Name'],
                            'remarks' => $list['Remarks'],
                            'b_group' => $list['B_Group'],
                        ]);
           
            if ($result !== false) $successCount++;
        }
        return $successCount === $totalCount ? $this->successUpdateResponse("All records updated successfully.") : $this->errorUpdateResponse("Failed to update some records.");
    }

}