<?php

namespace App\Http\Controllers;

use App\Models\ContactUsMessage;
use App\Models\ProjectOverview;
use App\Models\SubCategory;
use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Mail\SubscriptionMail;
use App\Mail\ContactUsMail;

class CommonCntroller extends Controller
{
    public function addSubscription(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|digits_between:10,15', 
            'location' => 'required|string|max:255'
        ]);
    
        if ($validation->fails()) {
            return response()->json([
                'errors' => $validation->errors()
            ], 422);
        }
    
        $obj = new Subscription();
        $obj->name = $request->name;
        $obj->phone = $request->phone;
        $obj->email = $request->email;
        $obj->location = $request->location;
      
        $version = 'v12.0';
        $phoneNumberId = "370526819468308";
        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";
        $cellNumber = '03041111544';
 
        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $cellNumber,
            'type' => 'template',
            'template' => [
                'name' => 'lead',
                'language' => [
                    'code' => 'en_US',
                ],
                'components' => [
                    [
                        'type' => 'body',
                        'parameters' => [
                            [
                                'type' => 'text',
                                'text' => $request->name,
                            ],
                            [
                            'type' => 'text',
                            'text' => $request->email,
                        ],
                        [
                            'type' => 'text',
                            'text' => $request->phone,
                        ],
                        [
                            'type' => 'text',
                            'text' => $request->location,
                        ],
                            
                        ],
                    ],
                 ],
             ],
         ];
 
         $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
         ->post($url, $payload);
         $status = $response->status();

    
        if ($obj->save()) {
            
            Mail::to('info@canalpalms.com')->send(new SubscriptionMail($obj));
        
    
            return response()->json([
                'message' => 'Record created successfully',
                'data' => $obj,
                'status' => $status,'body' => $response->body()
            ], 201); 
        } else {
            return response()->json([
                'message' => 'Record creation failed',
            ], 500);
        }
    }

    public function getSubscriptions()
    {
        $data = Subscription::paginate(25);
        if ($data->isEmpty()) {
            return response()->json([
                'message' => 'no record found!'
            ], 404);
        } else {
            return response()->json([
                'data' => $data
            ], 200);
        }
    }

    public function addContactUsMessage(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'first_name'=> 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email'     => 'required|email|max:255',
            'phone'     => 'required|digits_between:10,15', 
            'message'   => 'required'
        ]);
    
        if ($validation->fails()) {
            return response()->json([
                'errors' => $validation->errors()
            ], 422);
        }
    
        $obj = new ContactUsMessage();
        $obj->first_name = $request->first_name;
        $obj->last_name = $request->last_name;
        $obj->email = $request->email;
        $obj->phone = $request->phone;
        $obj->message = $request->message;

        $version = 'v12.0';
        $phoneNumberId = "370526819468308";
        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";
        $cellNumber = '03041111544';
 
        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $cellNumber,
            'type' => 'template',
            'template' => [
                'name' => 'contact_us',
                'language' => [
                    'code' => 'en_US',
                ],
                'components' => [
                    [
                        'type' => 'body',
                        'parameters' => [
                            [
                                'type' => 'text',
                                'text' => $request->first_name .' '. $request->last_name,
                            ],
                            [
                            'type' => 'text',
                            'text' => $request->email,
                        ],
                        [
                            'type' => 'text',
                            'text' => $request->phone,
                        ],
                        [
                            'type' => 'text',
                            'text' => $request->message,
                        ],
                            
                        ],
                    ],
                
                ],
            ],
        ];
 
        $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
            ->post($url, $payload);

        $status = $response->status();
    
        if ($obj->save()) {
            Mail::to('info@canalpalms.com')->send(new ContactUsMail($obj));

            return response()->json([
                'message' => 'Record created successfully',
                'data' => $obj,
                'status' => $status,'body' => $response->body()
            ], 201);
        } else {
            return response()->json([
                'message' => 'Record creation failed',
            ], 500);
        }
    }

    public function getContactUsMessages()
    {
        $data = ContactUsMessage::paginate(25);
        if($data->isEmpty())
        {
            return response()->json([
               'message' => 'no record found!'
            ], 404);
        } else {
            return response()->json([
                'data' => $data
             ], 200);
        }
    }

    public function getProjectOverview()
    {
        $data = ProjectOverview::first();
        return response()->json([
            'message' => 'record found',
            'data' => $data,
        ], 200);
    }

    public function updateProjectOverView(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'heading' => 'required',
            'title' => 'required',
            'text' => 'required',
        ]);
        if($validation->fails())
        {
            return response()->json([
                'message' => 'record updated successfully'
            ],200);
        }

        ProjectOverview::query()->update([
             'heading' => $request->heading,
              'title' => $request->heading,
              'text' => $request->text,
        ]);

        return response()->json([
           'message' => 'record updated successfully'
        ],200);
    }

    // public function getAmenities(Request $request)
    // {

    // }

    
}
