<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" /> 
	<title>Payment Notification</title>
	<link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
	<style>
	  body {
        font-family: "Urbanist", sans-serif;
        background: #f5f5f5;
        margin: 0;
        padding: 0;
      }
	  .main{
		width: 750px;
		margin: 20px auto;
		background: #fff;
		border: 1px solid #ddd;
	  }
	  .header{
		border-top: 5px solid #D2B34E;
		text-align: center;
		padding: 20px;
	  }
	  .header a{
		text-decoration:none;
		color:#333;
		font-size:32px;
		font-weight:700;
	  }
	  .content{
		padding: 30px;
	  }
	  .content h2{
		color:#333;
		font-size:22px;
		font-weight:700;
		margin-bottom:20px;
	  }
	  .detail-table{
		width:100%;
		border-collapse: collapse;
	  }
	  .detail-table th, .detail-table td{
		text-align:left;
		padding:10px;
		border-bottom:1px solid #eee;
	  }
	  .detail-table th{
		width:30%;
		color:#555;
	  }
	  .footer{
		border-bottom: 5px solid #D2B34E;
		text-align: center;
		padding: 15px;
		font-size: 13px;
		color:#555;
	  }
	  .footer a{
		color:#D2B34E;
		text-decoration: none;
	  }
	  th{
		font-weight: 800 !important;
	  }
	</style>
</head>
<body>
	<div class="main">
    <div class="header">
        <a href="https://canalpalms.com">Canal Palms</a>
    </div>

    <div class="content">
        <h2>New Payment Received</h2>
        <p>Dear Team, a new payment has been successfully received. Below are the details:</p>

        <table class="detail-table">
            <tr>
                <th>Customer Name</th>
                <td>{{ $customer->name }}</td>
            </tr>
            <tr>
                <th>Email</th>
                <td>{{ $customer->E_Mail }}</td>
            </tr>
            <tr>
                <th>Phone</th>
                <td>{{ $customer->Mob_No ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Plot Details</th>
                <td>{{ $customer->Plot_Name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Amount</th>
                <td>PKR {{ number_format($customer->amount, 2) }}</td>
            </tr>
            <tr>
                <th>Transaction ID</th>
                <td>{{ $customer->transaction_id ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Payment Date</th>
                <td>{{ $customer->paid_date }}</td>
            </tr>
        </table>

        <p style="margin-top:20px;">Please log in to the system to review more details.</p>
        <p style="margin-top:20px;">Regards,<br><strong>Canal Palms System</strong></p>
    </div>

    <div class="footer">
        © Copyright 2025 | All Rights Reserved |
        Powered By <a href="https://www.thesparksolutionz.com/">Spark Solutionz</a>
    </div>
</div>

</body>
</html>
