<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('city_tab', function (Blueprint $table) {
            $table->increments('City_ID');
            $table->integer('Comp_ID');
            $table->string('City_Name');
            $table->text('Remarks')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('city_tab');
    }
};
