<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('housing_unit_plots', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('server_id');
            $table->unsignedBigInteger('UP_ID');
            $table->unsignedBigInteger('Comp_ID');
            $table->unsignedBigInteger('Project_ID');
            $table->unsignedBigInteger('HUSC_ID');
            $table->unsignedBigInteger('HUP_ID');
            
            $table->unsignedBigInteger('HUSL_ID');
            $table->unsignedBigInteger('HUB_ID');
            $table->unsignedBigInteger('OS_LID');
            $table->float('UD_F');
            $table->float('UD_B');
            $table->float('UD_L');
            $table->float('UD_R');
            $table->float('U_W');
            $table->float('U_L');
            $table->float('UP_Marla');
            $table->integer('UPSys_Marla');
            $table->string('UP_Status')->nullable();
            $table->string('Size_Type');
            $table->string('UP_Type');
            $table->unsignedBigInteger('Sales_UP_ID');
            $table->unsignedBigInteger('CGS_UP_ID');
            $table->unsignedBigInteger('WIP_UP_ID');
            $table->float('Covered_Area');
            $table->unsignedBigInteger('HCS_ID');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('housing_unit_plots');
    }
};
