<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('sub_categories.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('sub_categories.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('sub_categories.updated_status',$updateStatus) ;

      }
    }
}