<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    public $table = 'Housing_Project';
    
    protected $guarded = [];
   

    protected function scopeWhereId($query, $id)
    {
        if ($id !== null)
            return $query->where('id', $id);
    }

    protected function scopeWhereUpdateStatus($query, $updateStatus)
    {
        if ($updateStatus !== null)
            return $query->where('updated_status', $updateStatus);
    }

    protected function scopeWhereServerId($query, $serverId)
    {
        if(!is_null($serverId[0]))
            return $query->whereIn('housing_unit_plots.server_id',$serverId);
    }
}