<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class HousingUnitPlot extends Model
{
  use HasApiTokens, HasFactory, Notifiable;

  protected $table = 'Housing_UnitPlot_Tab';
  public $timestamps = false; 
  protected $guarded = [];


  protected function scopeSearch($query, $searchTerm)
  {

    
    if (!is_null($searchTerm)) {
      return $query->whereRaw(
        'MATCH(Housing_UnitPlot_Tab.property_type, Housing_UnitPlot_Tab.city, Housing_UnitPlot_Tab.location, Housing_UnitPlot_Tab.category) AGAINST(?)',
        [$searchTerm]
      );
    }

    return $query;
  }
  protected function scopeWhereId($query, $id)
  {

    if (!is_null($id)) {
      return $query->where('Housing_UnitPlot_Tab. ID', $id);
    }

  }
  protected function scopeWherePlotsIn($query, $plotList)
  {

    if (!is_null($plotList)) {
      return $query->whereIn('Housing_UnitPlot_Tab.ID', explode(',', $plotList));
    }

  }


  protected function scopeWhereServerId($query, $serverId)
  {

    if (!is_null($serverId[0])) {

      return $query->whereIn('Housing_UnitPlot_Tab.server_id', $serverId);

    }

  }


  protected function scopeWhereUpdateAble($query, $updateStatus)
  {
    if (!is_null($updateStatus)) {
      return $query->where('Housing_UnitPlot_Tab.updated_status', $updateStatus);
    }
  }
  protected function scopeWherePropertyType($query, $type)
  {
    if (!is_null($type)) {
      return $query->where('Housing_UnitPlot_Tab.UP_Type', $type);
    }
  }

  protected function scopeWhereMin($query, $min)
  {
    if (!is_null($min)) {
      return $query->whereRaw('Housing_UnitPlot_Tab.Per_M_Rate * Housing_UnitPlot_Tab.UP_Marla >= ?', [$min]);
    }

  }

  protected function scopeWhereMax($query, $max)
  {
    if (!is_null($max)) {
      return $query->whereRaw('Housing_UnitPlot_Tab.Per_M_Rate * Housing_UnitPlot_Tab.UP_Marla <= ?', [$max]);
    }
  }

  protected function scopeWherePriceBetween($query, $minPrice, $maxPrice)
  {
    if (!is_null($minPrice) && !is_null($maxPrice)) {
      return $query->whereBetween('Housing_UnitPlot_Tab.Per_M_Rate', [$minPrice, $maxPrice]);
    }
  }


  protected function scopeFilterByDimension($query, $width, $length)
  {
    if (!is_null($width) && !is_null($length)) {
      return $query->whereBetween('Housing_UnitPlot_Tab.U_W', [$width, ceil($width)])
        ->whereBetween('Housing_UnitPlot_Tab.U_L', [$length, ceil($length)]);
    }
  }
  protected function scopeWhereWidth($query, $width)
  {
    if (!is_null($width)) {
      return $query->whereBetween('Housing_UnitPlot_Tab.U_W', [$width, $width + 1]);
    }
  }

  protected function scopeWhereLength($query, $length)
  {
    if (!is_null($length)) {
      return $query->where('Housing_UnitPlot_Tab.U_L', [$length, $length + 1]);
    }
  }

  protected function scopeWhereMarla($query, $marla)
  {
    if (!is_null($marla)) {
      return $query->where('Housing_UnitPlot_Tab.UP_Marla', '>=', (int)$marla)->where('Housing_UnitPlot_Tab.UP_Marla', '<', $marla + 1);
    }
  }

  protected function scopeWhereCity($query, $city)
  {
    if (!is_null($city)) {
      return $query->where('Housing_Project.P_City', $city);
    }
  }


  protected function scopeWhereLocation($query, $location)
  {
    if (!is_null($location)) {
      return $query->where('Housing_Project.P_Loc', $location);
    }
  }

  protected function scopeId($query, $id)
  {
    if (!is_null($id)) {
      return $query->where('Housing_UnitPlot_Tab.ID', $id);
    }
  }


  protected function scopeWhereStatus($query, $status)
  {
    if (!is_null($status)) {
      return $query->where('Housing_UnitPlot_Tab.UP_Status', $status);
    }

  }


  protected function scopeWhereCategory($query, $category)
  {
    if (!is_null($category)) {
      return $query->where('Housing_UnitPlot_Tab.HUP_ID', $category);
    }

  }

  protected function scopeFilterBYCategory($query, $category)
  {
    if (!is_null($category)) {
      return $query->where('categories.huc_name', $category);
    }

  }

  protected function scopeFilterByMarla($query, $marla)
  {
    if (!is_null($marla)) {

      return $query->whereBetween('Housing_UnitPlot_Tab.UP_Marla', [floor($marla), ceil($marla + 0.001)]);

    }
  }
  


}