<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{

    use HasFactory;
    protected $guarded = [];

    protected function scopeWhereId($query, $id)
    {
        if (!is_null($id))
            return $query->where('categories.id', $id);
    }
    
    protected function scopeWhereServerId($query, $serverId)
    {
        if (!is_null($serverId))
            return $query->whereIn('categories.server_id', $serverId);
    }
    
    protected function scopeWhereUpdateAble($query, $updateStatus)
    {
        if (!is_null($updateStatus))
            return $query->where('categories.updated_status', $updateStatus);

    }
    
}