<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
    use HasFactory;
    // protected $table = 'accounts';
    protected $connection = 'sqlsrv';
    protected $table = 'Account'; 
    public $timestamps = false;
    
    /*
        protected  $fillable = [
            'server_id',
            'Acco_LID',
            'Comp_ID'  ,
            'CAcco_ID' ,
            'Acco_Name',
            'Alias_Name',
            'Acco_Clas',
            'Sub_Clas' ,
            'Acco_Leve',
            'Status',
            'Acco_Leve1',
            'Sys_Acco',
            'Child_Acco',
            'Remarks',
            'User_ID',
            'Created_On',
            'Edited_By',
            'Edited_On',
            'B_Group' ,
            'Veh_Acco' ,
            'B_Group_Club' ,
            'Accrual_Acco'
        ];
     */

    protected $guarded = [];

    protected function scopeWhereId($query, $id)
    {
        if (!is_null($id))
            return $query->where('accounts.Acco_ID', $id);
    }

    protected function scopeWhereServerId($query, $serverId)
    {
        if (!is_null($serverId))
            return $query->whereIn('accounts.server_id', $serverId);

    }

    protected function scopeWhereUpdateAble($query, $updateStatus)
    {
        if (!is_null($updateStatus))
            return $query->where('accounts.updated_status', $updateStatus);
    }
}