<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Message;
use App\Traits\ApiResponseTrait;

class WebhookController extends Controller
{
        use ApiResponseTrait;

    // For verification when setting up webhook
    public function verify(Request $request)
    {
        $verify_token = 'myToken';
        if (
            $request->get('hub_mode') === 'subscribe' &&
            $request->get('hub_verify_token') === $verify_token
        ) {
            return response($request->get('hub_challenge'), 200);
        }
        
        return response('Invalid verification token', 403);
    }

    // To receive incoming WhatsApp messages
    public function receive(Request $request)
    {
        $entry = $request->input('entry');
        if (empty($entry)) {
            Log::warning('Empty entry in webhook payload.');
            return response('OK', 200);
        }

        $data = $request->all();
        if (isset($data['entry'][0]['changes'][0]['value']['messages'][0])) {
            $messageData = $data['entry'][0]['changes'][0]['value'];
            $wa_id = $messageData['contacts'][0]['wa_id'] ?? null;
            $name = $messageData['contacts'][0]['profile']['name'] ?? null;
            $message = $messageData['messages'][0]['text']['body'] ?? '';

            // Save to database
            Message::create([
                'phone'     => $wa_id,
                'name'      => $name,
                'message'   => $message,
            ]);
        }

        return response('EVENT_RECEIVED', 200);
    }

    public function getMessage(Request $request)
    {
        $data = Message::where('is_updateable','1')->get();
        return $data;
    }

    public function update(Request $request)
    {
        $ids = $request->input('update_id', []); 
        $ids = is_array($ids) ? $ids : [$ids];

        $execute = Message::whereIn('id', $ids)
            ->update(['is_updateable' => '0']);

        return $execute ? $this->successUpdateResponse($ids) : $this->errorUpdateResponse();
    }

}