<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
  public function login(UserRequest $request)
  {
    $user = User::where('email', $request->input('email'))->first();

    if (!$user || !Hash::check($request->input('password'), $user->password)) {
      return response()->json([
        'message' => 'invalida email or password',
      ], 404);
    }

    $token = $user->createToken('my-token')->plainTextToken;
    return response()->json([
      'message' => 'login successfully',
      'token' => $token,
    ], 200);

  }
  public function fetch()
  {
    return User::all();
  }

}