<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProjectRequest;
use App\Models\Project;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class ProjectController extends Controller
{
    use ApiResponseTrait;
    protected function indexV1(Request $request, $id = null)
    {
        try {

            $serverId = $this->setDefaultValue($request->server_id);
            $limit = $this->setDefaultValue($request->limit);
            $updateStatus = $this->setDefaultValue($request->update_status);

            $data = Project::select('id', 'name', 'city', 'image')
                ->whereId($id)
                ->whereUpdateStatus($updateStatus)
                ->whereServerId($serverId)
                ->paginate($limit);

                $pagination = [
                    
                    'page' => $data->currentPage(),
                    'total_record' => $data->total(),
                    'limit' => $limit,
                    'total_pages' => ceil($data->total() / $limit),
                ];

            return $data->isEmpty() ? $this->recordNotFoundResponse() : $this->recordFoundResponse($data->items(), 200, $pagination);

        } catch (Exception $e) {
            return response()->json(['error' => 'Something went wrong while fetching data' . $e], 500);
        }
    }


    protected function index(Request $request, $id = null)
    {
        try {

            $serverId = $this->setDefaultValue($request->server_id);
            $limit = $this->setDefaultValue($request->limit);
            $updateStatus = $this->setDefaultValue($request->update_status);

            $data = Project::whereId($id)
                ->whereUpdateStatus($updateStatus)
                ->whereServerId($serverId)
                ->paginate($limit);

            return $data->isEmpty() ? $this->recordNotFoundResponse() : $this->recordFoundResponse($data);

        } catch (Exception $e) {
            return response()->json(['error' => 'Something went wrong while fetching data' . $e], 500);
        }
    }

    protected function store(Request $request)
    {
        try {
            $stored = Project::insert($request->all());
            return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();

        } catch (Exception $e) {
            return response()->json(['error' => 'Something went wrong while storing data' . $e], 500);
        }
    }


    protected function update(Request $request, $id)
    {
        try {
            $request->merge(['updated_status' => '1']);
            $updated = Project::where('id', $id)->update($request->all());
            return $updated ? $this->successUpdateResponse($updated) : $this->errorUpdateResponse();
        } catch (Exception $e) {
            return response()->json(['error' => 'Something went wrong while updating data' . $e], 500);
        }
    }

    public function serverId()
    {
        $data = Project::select('server_id as id')->get();
        return $data->isNotEmpty()
            ? $this->successResponse($data, RECORD_FOUND, HTTP_OK)
            : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }

    public function changeUpdatedStatus(Request $request)
    {
        return $this->UpdatedStatus(Project::class, $request);
    }

    public function add(ProjectRequest $request)
    {

        $path = 'Null';
        $project = new Project();
        $project->name = $request->name;
        $project->city = $request->city;

        if ($request->has('image')) {
            $destination = "http://canalpalms-apis.sparksolutionz.com//public/projects/";
            $imageName = time() . '.' . $request->image->extension();
            $path = $destination . $imageName;
            $request->image->move(public_path('projects'), $path);
        }

        $project->image = $path;
        $result = $project->save();

        return ($result) ? $this->successInsertResponse($result) : $this->errorInsertResponse();

    }


    public function fetch()
    {
        $data = Project::select('name', 'city', 'image')->get();
        return $data->isNotEmpty() ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }
    

    public function edit(ProjectRequest $request)
    {
        /**
         * Wil be used to update the project record
         */
    }

}