<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\Company;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class CompanyController extends Controller
{
    use ApiResponseTrait;

    public function store(Request $request)
    {

        $stored = Company::insert($request->all());
        return $stored
            ? $this->successInsertResponse($stored)
            : $this->errorInsertResponse();

    }

    protected function update(Request $request)
    {
        $record = Company::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);
        
        $request->merge(['updated_status' => '1']);
        $record->update($request->all());

        $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }

    protected function index(Request $request, $id = null)
    {

        $serverId[] = $request->server_id;
        $limit = $request->input('limit', DEFAULT_LIMIT);
        $data = Company::whereId($id)
            ->whereServerId($serverId)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);
        if ($data)
            return $this->recordFoundResponse($data);
        else
            return $this->recordNotFoundResponse();
    }
    public function serverId()
    {
        $data = Company::select('server_id as id')
            ->get();
        return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = DB::table('companies')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        if ($execute)
            return $this->successUpdateResponse($serverIds);
        else
            return $this->errorUpdateResponse();

    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

    
        foreach ($request->data as $list) {

            $result = DB::table('companies')
                ->where('server_id', $list['server_id'])
                ->update([
                    'Comp_ID' => $list['Comp_ID'],
                    'Comp_Name' => $list['Comp_Name'],
                    'Comp_Addr' => $list['Comp_Addr'],
                    'Comp_Ph1' => $list['Comp_Ph1'],
                    'Comp_Ph2' => $list['Comp_Ph2'],
                    'Note1' => $list['Note1'],
                    'Note2' => $list['Note2'],
                    'B_Group' => $list['B_Group'],
                ]);

            if ($result !== false) {
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
    
    public function addBlog(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'text' => 'required',
            'img_1' => 'required|image',
            'img_2' => 'required|image',
            'position' => 'required'
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }
    
        $exists = Blog::where('position', $request->position)
            ->where('status', '<>', 'deleted')
            ->exists();
    
        if ($exists) {
            return response()->json('Position already exists', 409);
        }
    
        $blog = new Blog();
        $blog->title = $request->title;
        $blog->text = $request->text;
        $blog->position = $request->position;
    
        if ($request->hasFile('img_1')) {
            $img_1 = $request->file('img_1');
            $imageName_1 = uniqid('img1_').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('blog-images'), $imageName_1);
            $blog->img_1 = url('public/blog-images/'.$imageName_1);
        }
    
        if ($request->hasFile('img_2')) {
            $img_2 = $request->file('img_2');
            $imageName_2 = uniqid('img2_').'.'.$img_2->getClientOriginalExtension();
            $img_2->move(public_path('blog-images'), $imageName_2);
            $blog->img_2 = url('public/blog-images/'.$imageName_2);
        }
    
        if ($blog->save()) {
            return response()->json([
                'message' => 'Blog created successfully',
                'data' => $blog
            ], 200);
        } else {
            return response()->json([
                'message' => 'Something went wrong! Try again'
            ], 400);
        }
    }
    
    public function edit(Request $request , $id=null)
    {
        $validation = Validator::make($request->all(),[
            'title' => 'required',
            'text' => 'required',
            'position' => 'required'
        ]);
        if($validation->fails())
        {
            return response()->json([
               'message' => 'validation failed !',
               'errors' => $validation->errors(),
            ],422);
        }
        $blog = Blog::find($id);

        if($blog)
        {
            $exists = Blog::where('position', $request->position)
            ->where('status', '<>', 'deleted')
            ->where('id' ,'<>' , $id)
            ->exists();

            if ($exists) 
            {
                return response()->json('Position already exists', 409);
            }

            $blog->title = $request->title;
            $blog->text = $request->text;
            $blog->position = $request->position;

            if($request->hasFile('img_1'))
            {
                $img_1 = $request->file('img_1');
                $imageName_1 = uniqid('img1_').'.'.$img_1->getClientOriginalExtension();
                $img_1->move(public_path('blog-images') , $imageName_1);

                $blog->img_1  = 'https://canalpalms-apis.canalpalms.com/public/blog-images/'.$imageName_1;
            }
            if($request->hasFile('img_2'))
            {
                $img_2 = $request->file('img_2');
                $imageName_2 = uniqid('img2_').'.'.$img_2->getClientOriginalExtension();
                $img_2->move(public_path('blog-images') , $imageName_2);

                $blog->img_2  = 'https://canalpalms-apis.canalpalms.com/public/blog-images/'.$imageName_2;
            }

            if($blog->save())
            {
                return response()->json([
                    'message' => 'record updated successfully',
                ],200);
            }else{
                return response()->json([
                   'message' => 'something went wrong ! try again',
                ],400);
            }


        }else{
            return response()->json([
               'message' => 'no record found !',
            ],404);
        }
    }

    public function blog($id=null)
    {
        if(!is_null($id))
        {
            $blog = Blog::find($id);
            if(!$blog)
            {
                return response()->json(['message'=>'no record found'],404);
            }
            return response()->json(['data' => $blog] ,200 );
        }else{
            $blog = Blog::orderBy('position','asc')->where('status' ,'<>' ,'deleted')->get();
            if($blog->isEmpty())
            {
                return response()->json(['message'=>'no record found'],404);
            }
          return response()->json(['data' => $blog] ,200 );
        }
    }

    public function changeStatus($id , $status)
    {
        $blog = Blog::find($id);
        if($blog)
        {
             $blog->status = $status;
             if($blog->save())
             {
                return response()->json([
                    'message' => 'change status successfully'
                ],200);
             }else{
                return response()->json([
                    'message' => 'fail '
                ],400);
             }
        }else{
            return response()->json([
                'message' => 'no record found !'
            ],404);
        }
    }

}