<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BlogCotroller extends Controller
{
    public function addBlog(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'text' => 'required',
            'img_1' => 'required',
            'img_2' => 'required',
            'position' => 'required'
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }
    
        $exists = Blog::where('position', $request->position)
            ->where('status', '<>', 'deleted')
            ->exists();
    
        if ($exists) {
            return response()->json('Position already exists', 409);
        }
    
        $blog = new Blog();
        $blog->title = $request->title;
        $blog->text = $request->text;
        $blog->position = $request->position;
    
        if ($request->hasFile('img_1')) {
            $img_1 = $request->file('img_1');
            $imageName_1 = uniqid('img1_').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('blog-images'), $imageName_1);
            $blog->img_1 = url('public/blog-images/'.$imageName_1);
        }
    
        if ($request->hasFile('img_2')) {
            $img_2 = $request->file('img_2');
            $imageName_2 = uniqid('img2_').'.'.$img_2->getClientOriginalExtension();
            $img_2->move(public_path('blog-images'), $imageName_2);
            $blog->img_2 = url('public/blog-images/'.$imageName_2);
        }
    
        if ($blog->save()) {
            return response()->json([
                'message' => 'Blog created successfully',
                'data' => $blog
            ], 200);
        } else {
            return response()->json([
                'message' => 'Something went wrong! Try again'
            ], 400);
        }
    }
    
    public function edit(Request $request , $id=null)
    {
        $validation = Validator::make($request->all(),[
            'title' => 'required',
            'text' => 'required',
            'position' => 'required'
        ]);
        if($validation->fails())
        {
            return response()->json([
               'message' => 'validation failed !',
               'errors' => $validation->errors(),
            ],422);
        }
        $blog = Blog::find($id);

        if($blog)
        {
            $exists = Blog::where('position', $request->position)
            ->where('status', '<>', 'deleted')
            ->where('id' ,'<>' , $id)
            ->exists();

            if ($exists) 
            {
                return response()->json('Position already exists', 409);
            }

            $blog->title = $request->title;
            $blog->text = $request->text;
            $blog->position = $request->position;

            if($request->hasFile('img_1'))
            {
                $img_1 = $request->file('img_1');
                $imageName_1 = uniqid('img1_').'.'.$img_1->getClientOriginalExtension();
                $img_1->move(public_path('blog-images') , $imageName_1);

                $blog->img_1  = 'https://canalpalms-apis.canalpalms.com/public/blog-images/'.$imageName_1;
            }
            if($request->hasFile('img_2'))
            {
                $img_2 = $request->file('img_2');
                $imageName_2 = uniqid('img2_').'.'.$img_2->getClientOriginalExtension();
                $img_2->move(public_path('blog-images') , $imageName_2);

                $blog->img_2  = 'https://canalpalms-apis.canalpalms.com/public/blog-images/'.$imageName_2;
            }

            if($blog->save())
            {
                return response()->json([
                    'message' => 'record updated successfully',
                ],200);
            }else{
                return response()->json([
                   'message' => 'something went wrong ! try again',
                ],400);
            }


        }else{
            return response()->json([
               'message' => 'no record found !',
            ],404);
        }
    }

    public function blog($id=null)
    {
        if(!is_null($id))
        {
            $blog = Blog::find($id);
            if(!$blog)
            {
                return response()->json(['message'=>'no record found'],404);
            }
            return response()->json(['data' => $blog] ,200 );
        }else{
            $blog = Blog::orderBy('position','asc')->where('status' ,'<>' ,'deleted')->get();
            if($blog->isEmpty())
            {
                return response()->json(['message'=>'no record found'],404);
            }
          return response()->json(['data' => $blog] ,200 );
        }
    }

    public function changeStatus($id , $status)
    {
        $blog = Blog::find($id);
        if($blog)
        {
             $blog->status = $status;
             if($blog->save())
             {
                return response()->json([
                    'message' => 'change status successfully'
                ],200);
             }else{
                return response()->json([
                    'message' => 'fail '
                ],400);
             }
        }else{
            return response()->json([
                'message' => 'no record found !'
            ],404);
        }
    }
}
