<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Account;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccountController extends Controller
{
    use ApiResponseTrait;

    public function store(Request $request)// local server
    {

        $stored = Account::insert($request->all());
        if ($stored)
            return $this->successInsertResponse($stored);
        else
            return $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = Account::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);



        $request->merge(['updated_status' => '1']);
        $record->update($request->all());
        return $record
            ? $this->successUpdateResponse($record)
            : $this->errorUpdateResponse();
    }


    protected function index(Request $request, $id = null)
    {

        $serverId = $this->setDefaultValue($request->server_id);
        $limit = $this->setDefaultValue($request->limit);

        $data = Account::whereId($id)
            ->whereServerId($serverId)
            ->Where('Comp_ID', COMPANY_ID)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);

        return $data ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();

        
    }
    
    public function serverId() // local server
    {
        $data = Account::select('server_id as id')->Where('Comp_ID', COMPANY_ID)->get();
        return $data->isNotEmpty()
            ? $this->successResponse($data, RECORD_FOUND, HTTP_OK)
            : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }
    
    public function changeUpdatedStatus(Request $request)// local server
    {

        $serverIds = $request->server_id;
        $execute = Account::whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);

        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();

    }
    
    public function editbySql(Request $request)// local server
    {
        $successCount = 0;
        $totalCount = count($request->data);


        foreach ($request->data as $list) {


            $result = DB::table('accounts')
                ->where('server_id', $list['Acco_ID'])
                ->update([
                    'Acco_LID' => $list['Acco_LID'],
                    'Comp_ID' => $list['Comp_ID'],
                    'CAcco_ID' => $list['CAcco_ID'],
                    'Acco_Name' => $list['Acco_Name'],
                    'Alias_Name' => $list['Alias_Name'],
                    'Acco_Clas' => $list['Acco_Clas'],
                    'Sub_Clas' => $list['Sub_Clas'],
                    'Acco_Leve' => $list['Acco_Leve'],
                    'Status' => $list['Status'],
                    'Acco_Leve1' => $list['Acco_Leve1'],
                    'Sys_Acco' => $list['Sys_Acco'],
                    'Child_Acco' => $list['Child_Acco'],
                    'Remarks' => $list['Remarks'],
                    'User_ID' => $list['User_ID'],
                    'Comp_ID_All' => $list['Comp_ID_All'],
                    'B_Group' => $list['B_Group'],
                    'Veh_Acco' => $list['Veh_Acco'],
                    'B_Group_Club' => $list['B_Group_Club'],
                    'Accrual_Acco' => $list['Accrual_Acco'],
                ]);

            if ($result !== false) { // Check if update was successful
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
    public function updateAccount(Request $request)
    {
        $successCount = 0;
        // $totalCount = count($request->data);


        foreach ($request->data as $list) {


            $result = DB::table('accounts')
                ->where('id', $list['id'])
                ->update([
                    'Acco_ID' => $list['Acco_ID'],
                    'Acco_LID' => $list['Acco_LID'],
                    'server_id' => $list['Acco_ID'],
                    'CAcco_ID' => $list['CAcco_ID'],
                    'Alias_Name' => $list['Alias_Name'],
                ]);

            if ($result !== false) { // Check if update was successful
                $successCount++;
            }
        }

        if ($result) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
    public function addToSql(Request $request)
    {
        $server_ids = explode(',', $request->server_id);
        $data = Account::whereNotIn('server_id', $server_ids)->Where('Comp_ID', COMPANY_ID)->get();
    
        return $data;
    }
    


}