<?php

namespace App\Http\Controllers;

use App\Models\Account;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TestController extends Controller
{

    protected $table = 'Account'; // exact table name (case-sensitive in some setups)
    protected $connection = 'sqlsrv'; // tell Laravel to use the SQL Server connection

    private $epgUrl = 'https://ipg.comtrust.ae:2443';
    private $customer = 'CANAL PALMS';
    private $username = 'CANAL PALMS';
    private $password = 'DfKR*^a;aoPxwH';
    private $store = '0000';
    private $terminal = '0000';
    private $currency = 'PKR';
    private $channel = 'Web';
    private $transactionHint = 'CPT:Y;VCC:Y';
    // private $epgUrl = 'https://demo-ipg.ctdev.comtrust.ae:2443';
    // private $customer = 'Demo Merchant';
    // private $username = 'Demo_fY9c';
    // private $password = 'Comtrust@20182018';
    // private $store = '0000';
    // private $terminal = '0000';
    // private $currency = 'PKR';
    // private $channel = 'Web';
    // private $transactionHint = 'CPT:Y;VCC:Y';

    public function showPaymentForm()
    {
        return view('payment-form');
    }
    public function initiatePayment(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:0.01',
            'order_name' => 'required|string|max:255'
        ]);
        // Generate valid 16-digit numeric OrderID
        $orderID = time() . mt_rand(100000, 999999); // 10 + 6 digits
        $registrationData = [
            'Registration' => [
                'Customer' => $this->customer,
                'Currency' => $this->currency,
                'ReturnPath' => route('payment.callback'),
                'TransactionHint' => $this->transactionHint,
                'OrderID' => substr($orderID, 0, 16), // Ensure 16 digits0
                'Store' => $this->store,
                'Terminal' => $this->terminal,
                'Channel' => $this->channel,
                'Amount' => number_format($request->amount, 2),
                'OrderName' => $request->order_name,
                'UserName' => $this->username,
                'Password' => $this->password
            ]
        ];
        $response = Http::withoutVerifying()
            ->withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json'
            ])
            ->post($this->epgUrl, $registrationData);
        if ($response->successful() && $response['Transaction']['ResponseCode'] === '0') {
            return view('redirect-to-pg', [
                'paymentUrl' => $response['Transaction']['PaymentPortal'],
                'transactionId' => $response['Transaction']['TransactionID']
            ]);
        }
        return back()->withErrors('Payment failed: '.
            ($response['Transaction']['ResponseDescription'] ?? 'Unknown error'));
    }
    public function handleCallback(Request $request)
    {
        // \Log::info('Payment Callback', print_r($request->all(), true));
        $transactionId = $request->input('TransactionID');
        $finalizationData = [
            'Finalization' => [
                'TransactionID' => $transactionId,
                'Customer' => 'Demo Merchant',
                'UserName' => 'Demo_fY9c',
                'Password' => 'Comtrust@20182018'
            ]
        ];
        $response = Http::withoutVerifying()
            ->withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json'
            ])
            ->post($this->epgUrl, $finalizationData);
        if ($response->successful() && $response['Transaction']['ResponseCode'] === '0') {
            return view('payment-success', [
                'amount' => $response['Transaction']['Amount']['Value'],
                'approvalCode' => $response['Transaction']['ApprovalCode'],
                'cardNumber' => $response['Transaction']['CardNumber'],
                'transactionId' => $transactionId
            ]);
        }
        return view('payment-failed', [
            'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment failed'
        ]);
    }

   
    
    public function initiatePaymentApi(Request $request)
    {
       
        // Generate 16-digit numeric OrderID
        $orderID = substr(date('YmdHis') . mt_rand(1000, 9999), 0, 16);

        $registrationData = [
            'Registration' => [
                'Customer' => 'CANAL PALMS',
                'Currency' => 'PKR',
                'ReturnPath' => 'https://beta.canalpalms.com/payment/callback', 
                'TransactionHint' => 'CPT:Y;VCC:Y',
                'OrderID' => $orderID,
                'Store' => '0000',
                'Terminal' => '0000',
                'Channel' => 'Web',
                'Amount' => number_format(100, 2),
                'OrderName' => "Test",
                'UserName' => 'CANAL PALMS',
                'Password' => 'DfKR*^a;aoPxwH'
            ]
        ];

        try {
            $response = Http::withoutVerifying()
                ->withHeaders([
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ])
                ->post($this->epgUrl, $registrationData);

            if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                if ($response['Transaction']['ResponseCode'] === '0') {
                    return response()->json([
                        'payment_url' => $response['Transaction']['PaymentPortal'],
                        'transaction_id' => $response['Transaction']['TransactionID']
                    ]);
                }
                return response()->json([
                    'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment initiation failed'
                ], 400);
            }

            return response()->json(['error' => 'Payment gateway connection failed'], 500);

        } catch (\Exception $e) {
            Log::error('EPG Error: ' . $e->getMessage());
            return response()->json(['error' => 'Payment service unavailable'], 503);
        }
    }
   
    public function handleCallbackApi(Request $request)
    {
        $transactionId = $request->input('TransactionID');

        $finalizationData = [
            'Finalization' => [
                'TransactionID' => $transactionId,
                'Customer' => 'Demo Merchant',
                'UserName' => 'Demo_fY9c',
                'Password' => 'Comtrust@20182018'
            ]
        ];

        try {
            $response = Http::withoutVerifying()
                ->withHeaders([
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ])
                ->post($this->epgUrl, $finalizationData);

            if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                if ($response['Transaction']['ResponseCode'] === '0') {
                    return response()->json([
                        'status' => 'success',
                        'amount' => $response['Transaction']['Amount']['Value'],
                        'approval_code' => $response['Transaction']['ApprovalCode'],
                        'card_number' => $response['Transaction']['CardNumber'],
                        'transaction_id' => $transactionId
                    ]);
                }
                return response()->json([
                    'status' => 'failed',
                    'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment failed'
                ], 400);
            }

            return response()->json(['status' => 'error', 'error' => 'Payment verification failed'], 500);

        } catch (\Exception $e) {
            Log::error('EPG Finalization Error: ' . $e->getMessage());
            return response()->json(['status' => 'error', 'error' => 'Payment service unavailable'], 503);
        }
    }


    public function index()
    {
        $accounts = Account::all();
        return response()->json($accounts);
    }

    

}
