<?php

namespace App\Http\Controllers;

use Http;
use Illuminate\Http\Request;
use Log;
use Storage;
use Validator;

class SendPdfController extends Controller
{

    public function upload(Request $request)
    {

        $validate = Validator::make($request->all(), [
            'pdfs' => 'required',
            'pdfs.*' => 'mimes:pdf|max:30472',
        ]);

        if ($validate->fails())
            return ['errors' => $validate->errors()];


        $uploadedFiles = [];
        $whatsappResponse = [];

        $files = $request->file('pdfs');
        
    
        if ($request->hasFile('pdfs')) {

            foreach ($files as $file) {
                
             
                $filePath = $file->store('pdf', 'public');
                $fullUrl = "https://canalpalms-apis.canalpalms.com/storage/app/public/$filePath";
                $contact = $this->getContact($file);

                  
                $fileName = $file->getClientOriginalName();
                $contact = pathinfo($fileName, PATHINFO_FILENAME);


                $payload = [
                    "messaging_product" => "whatsapp",
                    "recipient_type" => "individual",
                    "to" => $contact,
                    "type" => "document",
                    "document" => [
                        "link" => $fullUrl,
                        "caption" => "Here’s your invoice; thank you for your business!",
                        "filename" =>  "Invoice",
                    ]
                ];


                $version = 'v12.0';
                $phoneNumberId = "370526819468308";
                $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";

                // Send the document via WhatsApp using the WhatsApp API
                $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
                    ->post($url, $payload);

                $whatsappResponse[] = ($response->successful()) ? [
                    'file' => $filePath,
                    'message' => 'Sent via WhatsApp successfully',
                    'link' => $fullUrl,
                    'response' => $response->json(),
                ] : [
                    'file' => $filePath,
                    'message' => 'Failed to send the document via WhatsApp',
                    'error' => $response->json(),
                ];

                $uploadedFiles[] = [
                    'filePath' => $filePath,
                    'fullUrl' => $fullUrl,
                ];

            }



        } else
            return "No file found";


        
        //  Return a JSON response with the file upload and WhatsApp statuses
        return response()->json([
           
            'uploaded_files' => $uploadedFiles,
            'whatsapp_responses' => $whatsappResponse,
        ]);
    }


    public function uploadV1(Request $request)
    {

        $request->validate(['pdf' => 'required|mimes:pdf|max:2048']);

        
        $file = $request->file('pdf');
        $filePath = $file->store('pdf', 'public');
        $contact = $this->getContact($file);

      
        $fullUrl = "https://canalpalms-apis.canalpalms.com/storage/app/public/$filePath";



        $payload = [
            "messaging_product" => "whatsapp",
            "recipient_type" => "individual",
            "to" => $contact,
            "type" => "document",
            "document" => [
                "link" => $fullUrl,
                "caption" => "Here’s your invoice; thank you for your business!",
                "filename" =>  "Invoice",
            ]
        ];



        $version = 'v12.0';
        $phoneNumberId = "370526819468308";
        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";

        $response = Http::withToken('EAALda3SkUT8BO5CZB4d0ZBFjZBw3e4AZCUtSgZBIcSQhemBxZC9uVbXOx4cDkGGpNcH4NFpUL07DjxFmhfZAZAmQ71JRCCNVFxbaNJHdPKcAqIWNFZBtoNzcAJhEhUeCcdx8dlwTto0lAyE5ZBDvD7ooXDSZAIj8SzqK9LylgnbM9ZCZAu1fHAZChcfucnIUVRh3hAbtOyFDgx0yGYoEx0yKpZB')
            ->post($url, $payload);

        if ($response->successful()) {
            return response()->json([
                'message' => 'PDF uploaded and sent via whatsApp successfully!',
                'link' => $fullUrl,
                'path' => $filePath,
                'response' => $response,
            ]);
        } else {
            return response()->json([
                'message' => 'Failed to send the document via WhatsApp!',
                'error' => $response->json()
            ], $response->status());
        }
    }


    private function getContact($file) {
        
        $fileName = $file->getClientOriginalName();
        $phoneNumber = pathinfo($fileName, PATHINFO_FILENAME);
        
       

        
    if (substr($phoneNumber, 0, 2) === '92' || substr($phoneNumber, 0, 3) === '+92') {
    
        $updatedPhoneNumber = $phoneNumber;

    } elseif (substr($phoneNumber, 0, 1) === '0') {
  
        $updatedPhoneNumber = '92' . substr($phoneNumber, 1);
    
    } else {
   
        $updatedPhoneNumber = "92$phoneNumber";
    
    }

        return $updatedPhoneNumber;  // Output the result

    }

}