<?php

namespace App\Http\Controllers;

use App\Models\HousingProject;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;

class HousingProjectController extends Controller
{
    use ApiResponseTrait;
    protected function store(Request $request)
    {
        if (count($request->all()) <= 0) {
            return response()->json([
                'message' => 'No record to insert',
            ], 404);
            dd($request);

        }
        $stored = HousingProject::insert($request->all());
        return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }

    protected function index(Request $request, $id = null)
    {
        try {

            $limit = $request->input('limit', DEFAULT_LIMIT);
            $serverId = $request->server_id;

            $data = HousingProject::whereId($id)
                ->whereUpdateStatus($request->updated_status)
                ->whereServerId($serverId)
                ->paginate($limit);


            return ($data->isEmpty()) ? $this->recordNotFoundResponse() : $this->recordFoundResponse($data);


        } catch (Exception $e) {

            return response()->json(['error' => 'Something went wrong while fetching data' . $e], 500);
        }
    }

    protected function update(Request $request, $id)
    {
        try {

            $request->merge(['updated_status' => '1']);
            $updated = HousingProject::where('id', $id)->update($request->all());

            return $updated ? $this->successUpdateResponse($updated) : $this->errorUpdateResponse();

        } catch (Exception $e) {
            return response()->json(['error' => 'Something went wrong while updating data' . $e], 500);
        }
    }

    public function serverId()
    {
        $data = HousingProject::select('server_id as id')->get();
        return $data->isNotEmpty() ? $this->successResponse($data, RECORD_FOUND, HTTP_OK) : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }

    public function fetch()
    {
        $data = HousingProject::select(
            'housing_projects.name',
            DB::raw('COALESCE(housing_projects.p_city, "Sargodha") as city'),
            'housing_projects.image',
        )
            ->join('companies', 'housing_projects.comp_id', 'companies.Comp_ID')
            ->where('housing_projects.id' ,'<>',1)
            ->get();

        return $data->isNotEmpty() ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }

    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = DB::table('housing_projects')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);
        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();
    }

    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);


        foreach ($request->data as $list) {

            $result = DB::table('housing_projects')
                ->where('server_id', $list['server_id'])
                ->update([
                    'comp_id' => $list['comp_id'],
                    'project_id' => $list['project_id'],
                    'start_date' => $list['start_date'],
                    'emp_id' => $list['emp_id'],
                    'p_loc' => $list['p_loc'],
                    'p_city' => $list['p_city'],
                    'marla_sqf' => $list['marla_sqf'],
                    'sales_project_id' => $list['sales_project_id'],
                    'hr_project_cgs' => $list['hr_project_cgs'],
                    'wip_project_id' => $list['wip_project_id'],
                ]);

            if ($result !== false)
                $successCount++;

        }

        if ($successCount === $totalCount)
            return $this->successUpdateResponse(" records updated successfully.");
        else
            return $this->errorUpdateResponse("Failed to update  records.");

    }


    public function projectsReport(Request $request)
    {
        return HousingProject::select('companies.compp_name as company', 'housing_projects.name as project')
            ->paginate(25);
    }

}