<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CategoryController extends Controller
{
    use ApiResponseTrait;

    public function store(Request $request)
    {
        if (count($request->all()) <= 0) {
            return response()->json([
                'message' => 'No record to insert',
            ], 404);
            dd($request);

        }
        $stored = Category::insert($request->all());
        return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();
    }


    protected function update(Request $request)
    {
        $record = Category::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);
        $request->merge(['updated_status' => '1',]);
        $record->update($request->all());

        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();

    }


    protected function index(Request $request, $id = null)
    {

        $serverId = $this->setDefaultValue($request->server_id);
        $limit = $this->setDefaultValue($request->limit);
        $updateStatus = $this->setDefaultValue($request->update_status);


        $data = Category::select(
            'server_id',
            'comp_id',
            'huc_name',
            'remarks',
            'b_group',
            'updated_status'
        )
            ->whereId($id)
            ->whereServerId($serverId)
            ->whereUpdateAble($updateStatus)
            ->paginate($limit);



        return $data->isNotEmpty() ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();
    }

    public function serverId()
    {
        $data = Category::select('server_id as id')->get();

        return $data->isNotEmpty()
            ? $this->successResponse($data, RECORD_FOUND, HTTP_OK)
            : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }

    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;
        $execute = Category::whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);

        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();

    }

    public function editbySql(Request $request)
    {

        $successCount = 0;
        $totalCount = count($request->data);

        foreach ($request->data as $list) {
            $result = DB::table('categories')
                ->where('server_id', $list['server_id'])
                ->update([
                    'comp_id' => $list['Comp_ID'],
                    'huc_name' => $list['HUC_Name'],
                    'remarks' => $list['Remarks'],
                    'b_group' => $list['B_Group'],
                ]);

            if ($result !== false)
                $successCount++;
        }

        if ($successCount === $totalCount)
            return $this->successUpdateResponse("All records updated successfully.");
        else
            return $this->errorUpdateResponse("Failed to update some records.");

    }

    public function list()
    {

        $data = Category::select('id', 'huc_name as name')->get();
        return ($data->isEmpty()) ? $this->recordNotFoundResponse() : $this->recordFoundResponse($data);
    }

}