<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_persons', function (Blueprint $table) {
            $table->id();
            $table->string('server_id');
            $table->string('edit_id')->nullable();
            $table->string('comp_id')->nullable();
            $table->string('sale_person_id')->nullable();
            $table->string('sale_person_name')->nullable();
            $table->string('per_ph')->nullable();
            $table->string('per_mob')->nullable();
            $table->string('email')->nullable();
            $table->string('route_id')->nullable();
            $table->string('aa_id')->nullable();
            $table->string('sa_id')->nullable();
            $table->string('ad_id')->nullable();
            $table->string('city_id')->nullable();
            $table->string('addr1')->nullable();
            $table->string('addr2')->nullable();
            $table->string('veh_id')->nullable();
            $table->string('comm_per')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_persons');
    }
};
