<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('housing_charges_schedule', function (Blueprint $table) {
            $table->increments('HCS_ID');
            $table->integer('Comp_ID');
            $table->string('HCS_Name');
            $table->text('Remarks')->nullable();
            $table->string('B_Group')->nullable();
            $table->enum('updated_status',['0','1'])->default(0);
            $table->timestamps();
     
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('housing_charges_schedule');
    }
};
