<?php

namespace App\Traits;

trait ApiResponseTrait
{

    // Response for record found
    public function recordFoundResponse($data, $statusCode = 200, $pagination = null, $query = null)
    {
        return $this->successResponse($data, 'Record found.', $statusCode, $pagination, $query);
    }





    // Response for record not found
    public function recordNotFoundResponse($statusCode = 404)
    {
        return $this->generalResponse('Record not found.', $statusCode);
    }

    // Response for successful insert
    public function successInsertResponse($data, $statusCode = 201, $pagination = null)
    {
        return $this->successResponse($data, 'Record inserted successfully.', $statusCode, $pagination);
    }

    // Response for successful update
    public function successUpdateResponse($data, $statusCode = 200, $pagination = null)
    {
        return $this->successResponse($data, 'Record updated successfully.', $statusCode, $pagination);
    }

    // Response for successful delete
    public function successDeleteResponse($statusCode = 204)
    {
        return $this->generalResponse('Record deleted successfully.', $statusCode);
    }

    // Response for unsuccessful insert
    public function errorInsertResponse($statusCode = 400)
    {
        return $this->generalResponse('Failed to insert record.', $statusCode);
    }

    // Response for unsuccessful update
    public function errorUpdateResponse($statusCode = 400)
    {
        return $this->generalResponse('Failed to update record.', $statusCode);
    }

    // Response for unsuccessful delete
    public function errorDeleteResponse($statusCode = 400)
    {
        return $this->generalResponse('Failed to delete record. Please try again...!', $statusCode);
    }

    // Response for unsuccessful get
    public function errorGetResponse($statusCode = 404)
    {
        return $this->generalResponse('Record not found.', $statusCode);
    }

    // Generic success response
    public function successResponse($data, $message = null, $statusCode = 200, $pagination = null, $query = null, )
    {
        if ($pagination !== null) {
            return response()->json([
                'message' => $message,
                'data' => $data,
                'pagination' => $pagination,
                'query' => $query,
            ], $statusCode);
        }
        return response()->json([
            'message' => $message,
            'data' => $data,
            'query' => $query,
        ], $statusCode);
    }

    // Generic response for general cases
    public function generalResponse($message, $statusCode = 200)
    {
        return response()->json([
            'message' => $message
        ], $statusCode);
    }
}