<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StreetLane extends Model
{
    protected $guarded = [];

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('street_lanes.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('street_lanes.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('street_lanes.updated_status',$updateStatus) ;

      }
    }
    use HasFactory;
}