<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LedgerDetailBpv extends Model
{
    use HasFactory;
    protected $table = 'ledger_detail_bpvs';
    
    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('ledger_detail_bpvs.Ledger_ID',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('ledger_detail_bpvs.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('ledger_detail_bpvs.updated_status',$updateStatus) ;

      }
    }
}