<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HousingSaleTokenChill extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $table = 'Housing_Sale_Token_Chil';
    
    public $timestamps = false;

    protected function scopeWhereId($query, $id)
    {
        if(!is_null($id))
            return $query->where('Housing_Sale_Token_Chil.id', $id) ;
        
    }
    
    protected function scopeWhereServerId($query, $serverId)
    {
        if(!is_null($serverId))
            return $query->whereIn('Housing_Sale_Token_Chil.server_id', $serverId) ;
        
    }
    
    protected function scopeWhereUpdateAble($query, $updateStatus)
    {
      if(!is_null($updateStatus))
        return $query->where('Housing_Sale_Token_Chil.updated_status', $updateStatus) ;

    }
    
}