<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HousingUnitPlotIndexResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [

            'id' => $this->id,
            'server_id' => $this->server_id,
            'price' => number_format($this->price),
            'up_id' => $this->UP_ID,
            'comp_id' => $this->Comp_ID,
            'project_id' => $this->Project_ID,
            'huc_id' => $this->HUC_ID,
            'husc_id' => $this->HUSC_ID,
            'hup_id' => $this->HUP_ID,
            'husl_id' => $this->HUSL_ID,
            'hub_id' => $this->HUB_ID,
            'hus_id' => $this->HUS_ID,
            'os_lid' => $this->OS_LID,
            'ud_f' => round($this->UD_F, 2),
            'ud_b' => round($this->UD_B, 2),
            'ud_l' => round($this->UD_L, 2),
            'ud_r' => round($this->UD_R, 2),
            'uw' => round($this->U_W, 2),
            'ul' => round($this->U_L, 2),
            'up_marla' => round($this->UP_Marla, 2),
            'up_sys_marla' => round($this->UPSys_Marla, 2),
            'up_status' => $this->UP_Status,
            'size_type' => $this->Size_Type,
            'up_type' => $this->UP_Type,
            'sales_up_id' => $this->Sales_UP_ID,
            'cgs_up_id' => $this->CGS_UP_ID,
            'wip_up_id' => $this->WIP_UP_ID,
            'covered_area' => round($this->Covered_Area, 2),


        ];
    }
}